/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.rollbar.android.RollbarExceptionHandler;
import com.rollbar.android.RollbarThread;
import com.rollbar.android.http.HttpRequestManager;
import com.rollbar.android.http.HttpResponse;
import com.rollbar.android.http.HttpResponseHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Notifier {
    private static int \u02cf = 0;
    private volatile boolean \u0971;
    private final ScheduledExecutorService \u02ce = Executors.newSingleThreadScheduledExecutor();
    private final String \u02cb;
    private final String \u02ca;
    private JSONObject \u02bd;
    private String \u141d;
    private boolean \u02bc;
    private boolean \u02ca\u0971;
    private String \u02bb;
    private String \u037a;
    private boolean \u02cb\u0971;
    private int \u0971\u02ca;
    private int \u0971\u02cb;
    private String \u02cf\u0971;
    private final File \u0971\u02ce;
    private final RollbarThread \u02bb\u0971;

    public Notifier(Context context, String string2, String string3, boolean bl) {
        this.\u02cb = string2;
        this.\u02ca = string3;
        try {
            string2 = context.getPackageName();
            string2 = context.getPackageManager().getPackageInfo(string2, 0);
            this.\u0971\u02cb = ((PackageInfo)string2).versionCode;
            this.\u02cf\u0971 = ((PackageInfo)string2).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"Rollbar", (String)"Error getting package info.");
        }
        this.\u141d = "https://api.rollbar.com/api/1/items/";
        this.\u02bc = true;
        this.\u02bb = "warning";
        this.\u037a = "error";
        this.\u02cb\u0971 = false;
        this.\u0971\u02ca = 30;
        this.\u0971 = false;
        this.\u0971\u02ce = new File(context.getCacheDir(), "rollbar-items");
        this.\u0971\u02ce.mkdirs();
        if (bl) {
            RollbarExceptionHandler.register(this);
        }
        this.\u02bb\u0971 = new RollbarThread(this);
        this.\u02bb\u0971.start();
        this.\u02ce(1);
    }

    private static JSONArray \u0971() {
        JSONArray jSONArray = null;
        int n = android.os.Process.myPid();
        try {
            String string2;
            Object object = Runtime.getRuntime().exec("logcat -d");
            object = new InputStreamReader(((Process)object).getInputStream());
            object = new BufferedReader((Reader)object, 8192);
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                if (!string2.contains(String.valueOf(n))) continue;
                arrayList.add(string2);
                if (arrayList.size() <= 100) continue;
                arrayList.remove(0);
            }
            jSONArray = new JSONArray(arrayList);
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to collect logcat info.", (Throwable)iOException);
        }
        return jSONArray;
    }

    private JSONObject \u02ce(String object, JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("environment", (Object)this.\u02ca);
        jSONObject2.put("level", object);
        jSONObject2.put("platform", (Object)"android");
        jSONObject2.put("framework", (Object)"android");
        jSONObject2.put("language", (Object)"java");
        jSONObject2.put("body", (Object)jSONObject);
        if (this.\u02bd != null) {
            jSONObject2.put("person", (Object)this.\u02bd);
        }
        object = this;
        jSONObject = new JSONObject();
        jSONObject.put("timestamp", System.currentTimeMillis() / 1000L);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("phone_model", (Object)Build.MODEL);
        jSONObject3.put("android_version", (Object)Build.VERSION.RELEASE);
        jSONObject3.put("code_version", (Object)((Notifier)object).\u02cf\u0971);
        jSONObject3.put("version_code", ((Notifier)object).\u0971\u02cb);
        jSONObject3.put("version_name", (Object)((Notifier)object).\u02cf\u0971);
        if (((Notifier)object).\u02ca\u0971) {
            jSONObject3.put("logs", (Object)Notifier.\u0971());
        }
        jSONObject.put("android", (Object)jSONObject3);
        jSONObject.put("user_ip", (Object)"$remote_ip");
        jSONObject2.put("client", (Object)jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put("name", (Object)"rollbar-android");
        jSONObject.put("version", (Object)"0.2.0");
        jSONObject2.put("notifier", (Object)jSONObject);
        return jSONObject2;
    }

    private static JSONArray \u02cb(File file) {
        Log.d((String)"Rollbar", (String)"Loading items...");
        JSONArray jSONArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            while (fileInputStream.read(byArray) != -1) {
                stringBuilder.append(new String(byArray));
            }
            fileInputStream.close();
            jSONArray = new JSONArray(stringBuilder.toString());
            Log.d((String)"Rollbar", (String)"Items loaded.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.e((String)"Rollbar", (String)"Unable to read item file.", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to read item file.", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"Invalid item data. Deleting file.", (Throwable)jSONException);
            file.delete();
        }
        return jSONArray;
    }

    public File writeItems(JSONArray jSONArray) {
        Log.d((String)"Rollbar", (String)"Writing items...");
        try {
            Object object = \u02cf++ + "." + System.currentTimeMillis();
            object = new File(this.\u0971\u02ce, (String)object);
            FileWriter fileWriter = new FileWriter((File)object);
            fileWriter.write(jSONArray.toString());
            fileWriter.close();
            Log.d((String)"Rollbar", (String)"Items written");
            return object;
        }
        catch (IOException iOException) {
            Log.e((String)"Rollbar", (String)"Unable to write items.", (Throwable)iOException);
            return null;
        }
    }

    public void postItems(JSONArray jSONArray, File file) {
        Notifier notifier;
        Log.i((String)"Rollbar", (String)"Sending item batch...");
        try {
            JSONArray jSONArray2 = jSONArray;
            notifier = this;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("access_token", (Object)notifier.\u02cb);
            jSONObject.put("data", (Object)jSONArray2);
            notifier = jSONObject;
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return;
        }
        HttpRequestManager.getInstance().postJson(this.\u141d, (JSONObject)notifier, false, new HttpResponseHandler(this, file, jSONArray){
            private /* synthetic */ File \u02cb;
            private /* synthetic */ JSONArray \u0971;
            private /* synthetic */ Notifier \u02cf;
            {
                this.\u02cf = notifier;
                this.\u02cb = file;
                this.\u0971 = jSONArray;
            }

            @Override
            public final void onSuccess(HttpResponse httpResponse) {
                Log.i((String)"Rollbar", (String)"Success");
                if (this.\u02cb != null) {
                    this.\u02cb.delete();
                }
            }

            @Override
            public final void onFailure(HttpResponse httpResponse) {
                Log.e((String)"Rollbar", (String)"There was a problem reporting to Rollbar.");
                Log.e((String)"Rollbar", (String)("Response: " + httpResponse));
                if (httpResponse.hasStatusCode() && httpResponse.has4xxStatusCode()) {
                    if (this.\u02cb != null) {
                        this.\u02cb.delete();
                        return;
                    }
                } else {
                    if (this.\u02cb == null) {
                        this.\u02cf.writeItems(this.\u0971);
                    }
                    this.\u02cf.\u02ce(this.\u02cf.\u0971\u02ca);
                }
            }
        });
    }

    private void \u02ce(int n) {
        if (!this.\u0971) {
            this.\u0971 = true;
            Log.d((String)"Rollbar", (String)"Scheduling item file handler...");
            this.\u02ce.schedule(new Runnable(this){
                private /* synthetic */ Notifier \u02cf;
                {
                    this.\u02cf = notifier;
                }

                @Override
                public final void run() {
                    Log.d((String)"Rollbar", (String)"Item file handler running...");
                    for (File file : this.\u02cf.\u0971\u02ce.listFiles()) {
                        JSONArray jSONArray = Notifier.\u02cb(file);
                        this.\u02cf.postItems(jSONArray, file);
                    }
                    Notifier.\u0971(this.\u02cf);
                    Log.d((String)"Rollbar", (String)"Item file handler finished.");
                }
            }, (long)n, TimeUnit.SECONDS);
        }
    }

    private static JSONObject \u02cb(Throwable throwable, String string2) throws JSONException {
        ByteArrayOutputStream byteArrayOutputStream;
        Object object;
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            object = stackTraceElementArray[i];
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("class_name", (Object)((StackTraceElement)object).getClassName());
            jSONObject2.put("filename", (Object)((StackTraceElement)object).getFileName());
            jSONObject2.put("method", (Object)((StackTraceElement)object).getMethodName());
            if (((StackTraceElement)object).getLineNumber() > 0) {
                jSONObject2.put("lineno", ((StackTraceElement)object).getLineNumber());
            }
            jSONArray.put((Object)jSONObject2);
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace((PrintStream)object);
            ((PrintStream)object).close();
            byteArrayOutputStream.close();
            jSONObject.put("raw", (Object)byteArrayOutputStream.toString("UTF-8"));
        }
        catch (Exception exception) {
            Log.e((String)"Rollbar", (String)"Exception printing stack trace.", (Throwable)exception);
        }
        byteArrayOutputStream = new JSONObject();
        byteArrayOutputStream.put("class", throwable.getClass().getName());
        byteArrayOutputStream.put("message", throwable.getMessage());
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            byteArrayOutputStream.put("description", string2);
        }
        jSONObject.put("frames", (Object)jSONArray);
        jSONObject.put("exception", (Object)byteArrayOutputStream);
        return jSONObject;
    }

    public void uncaughtException(Throwable throwable) {
        if (this.\u02bc) {
            Log.d((String)"Rollbar", (String)"Handling uncaught exception...");
            this.\u02bb\u0971.interrupt();
            throwable = this.\u0971(throwable, this.\u037a, null, new HashMap<String, String>());
            if (throwable != null) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)throwable);
                if (this.\u02cb\u0971) {
                    this.postItems(jSONArray, null);
                } else {
                    this.writeItems(jSONArray);
                }
            }
            try {
                this.\u02bb\u0971.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                Log.d((String)"Rollbar", (String)"Couldn't join rollbar thread", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject \u0971(Throwable object, String string2, String object22, Map<String, String> map) {
        try {
            void var4_6;
            JSONObject jSONObject = new JSONObject();
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
            do {
                arrayList.add(0, Notifier.\u02cb((Throwable)((Object)object), (String)object22));
            } while ((object = ((Throwable)((Object)object)).getCause()) != null);
            object = new JSONArray(arrayList);
            jSONObject.put("trace_chain", (Object)object);
            if (string2 == null) {
                string2 = this.\u02bb;
            }
            for (Map.Entry entry : var4_6.entrySet()) {
                jSONObject.put((String)entry.getKey(), entry.getValue());
            }
            return this.\u02ce(string2, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    private JSONObject \u02ca(String object, String string2, Map<String, String> object22) {
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("body", (Object)object);
            jSONObject.put("message", (Object)jSONObject2);
            for (Map.Entry entry : object22.entrySet()) {
                jSONObject2.put((String)entry.getKey(), entry.getValue());
            }
            return this.\u02ce(string2, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"There was an error constructing the JSON payload.", (Throwable)jSONException);
            return null;
        }
    }

    public void reportException(Throwable throwable, String string2, String string3) {
        if ((throwable = this.\u0971(throwable, string2, string3, new HashMap<String, String>())) != null) {
            this.\u02bb\u0971.queueItem((JSONObject)throwable);
        }
    }

    public void reportException(Throwable throwable, String string2, String string3, Map<String, String> map) {
        if ((throwable = this.\u0971(throwable, string2, string3, map)) != null) {
            this.\u02bb\u0971.queueItem((JSONObject)throwable);
        }
    }

    public void reportMessage(String string2, String string3) {
        if ((string2 = this.\u02ca(string2, string3, new HashMap<String, String>())) != null) {
            this.\u02bb\u0971.queueItem((JSONObject)string2);
        }
    }

    public void reportMessage(String string2, String string3, Map<String, String> map) {
        if ((string2 = this.\u02ca(string2, string3, map)) != null) {
            this.\u02bb\u0971.queueItem((JSONObject)string2);
        }
    }

    public void setPersonData(JSONObject jSONObject) {
        this.\u02bd = jSONObject;
    }

    public void setPersonData(String string2, String string3, String string4) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", (Object)string2);
            if (string3 != null) {
                jSONObject.put("username", (Object)string3);
            }
            if (string4 != null) {
                jSONObject.put("email", (Object)string4);
            }
            this.\u02bd = jSONObject;
            return;
        }
        catch (JSONException jSONException) {
            Log.e((String)"Rollbar", (String)"JSON error creating person data.", (Throwable)jSONException);
            return;
        }
    }

    public void setEndpoint(String string2) {
        this.\u141d = string2;
    }

    public void setReportUncaughtExceptions(boolean bl) {
        this.\u02bc = bl;
    }

    public void setIncludeLogcat(boolean bl) {
        this.\u02ca\u0971 = bl;
    }

    public void setDefaultCaughtExceptionLevel(String string2) {
        this.\u02bb = string2;
    }

    public void setUncaughtExceptionLevel(String string2) {
        this.\u037a = string2;
    }

    public void setSendOnUncaughtException(boolean bl) {
        this.\u02cb\u0971 = bl;
    }

    public void setItemScheduleDelay(int n) {
        this.\u0971\u02ca = n;
    }

    static /* synthetic */ boolean \u0971(Notifier notifier) {
        notifier.\u0971 = false;
        return false;
    }
}

