/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android.http;

import android.util.Log;
import com.rollbar.android.http.HttpRequestManager;
import com.rollbar.android.http.HttpResponse;
import com.rollbar.android.http.HttpResponseHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest
implements Runnable {
    private URL \u02ca;
    private HttpResponseHandler \u0971;
    private HttpURLConnection \u02ce;
    private HashMap<String, String> \u02cf;
    private String \u02cb;
    private byte[] \u02bd;
    private int \u141d;

    public HttpRequest(URL uRL, String string2, HttpResponseHandler httpResponseHandler) {
        this.\u02ca = uRL;
        this.\u02cb = string2;
        this.\u0971 = httpResponseHandler;
        this.\u02cf = new HashMap();
        this.\u141d = 1;
    }

    public void setMethod(String string2) {
        this.\u02cb = string2;
    }

    public void setRequestProperty(String string2, String string3) {
        this.\u02cf.put(string2, string3);
    }

    public void setBody(String string2) {
        try {
            this.\u02bd = string2.getBytes("UTF-8");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e((String)"Rollbar", (String)("Cannot encode body: " + unsupportedEncodingException.toString()));
            return;
        }
    }

    @Override
    public void run() {
        try {
            this.\u02ce = (HttpURLConnection)this.\u02ca.openConnection();
        }
        catch (IOException iOException) {
            this.\u02cf(new HttpResponse(iOException.toString()));
            return;
        }
        try {
            int n;
            this.\u02ce.setRequestMethod(this.\u02cb);
            this.\u02ce.setConnectTimeout(5000);
            this.\u02ce.setReadTimeout(5000);
            for (Map.Entry<String, String> object2 : this.\u02cf.entrySet()) {
                this.\u02ce.setRequestProperty(object2.getKey(), object2.getValue());
            }
            if (this.\u02bd != null) {
                this.\u02ce.setDoOutput(true);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.\u02ce.getOutputStream());
                ((OutputStream)bufferedOutputStream).write(this.\u02bd);
                ((OutputStream)bufferedOutputStream).close();
            }
            String string2 = HttpRequest.\u02cb(new BufferedInputStream((n = this.\u02ce.getResponseCode()) == 200 ? this.\u02ce.getInputStream() : this.\u02ce.getErrorStream()));
            HttpResponse httpResponse = new HttpResponse(n, string2);
            if (n == 200) {
                this.\u0971.onSuccess(httpResponse);
            } else {
                this.\u02cf(httpResponse);
            }
            return;
        }
        catch (IOException iOException) {
            this.\u02cf(new HttpResponse(iOException.toString()));
            return;
        }
        finally {
            this.\u02ce.disconnect();
        }
    }

    private void \u02cf(HttpResponse httpResponse) {
        if (this.\u141d < 5 && !httpResponse.hasStatusCode()) {
            ++this.\u141d;
            HttpRequestManager.getInstance().retryRequest(this);
            return;
        }
        this.\u0971.onFailure(httpResponse);
    }

    public int getAttemptNumber() {
        return this.\u141d;
    }

    private static String \u02cb(BufferedInputStream bufferedInputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        String string2 = "";
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            string2 = string2.concat(new String(byArray, 0, n));
        }
        return string2;
    }
}

