/*
 * Decompiled with CFR 0.152.
 */
package com.raybritton.htmltableparser;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;
import com.raybritton.htmltableparser.models.Cell;

public class TableColumnSpan
extends ReplacementSpan {
    private final int widthPx;
    private final int padding;
    private final int margin;
    private final Paint backgroundPaint;
    private final boolean isBold;
    private final Paint.Align textAlignment;

    public TableColumnSpan(int widthPx, int padding, int margin, Cell cell) {
        this.widthPx = widthPx;
        this.padding = padding;
        this.margin = margin;
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(cell.getBackgroundColor());
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.isBold = cell.isBold();
        this.textAlignment = this.convertGravity(cell.getGravity());
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        return this.widthPx;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        canvas.drawRect(x + (float)this.margin, (float)top, x + (float)this.widthPx + (float)this.margin, (float)bottom, this.backgroundPaint);
        paint.setFakeBoldText(this.isBold);
        paint.setTextAlign(this.textAlignment);
        canvas.drawText(text, start, end, this.getAdjustedX(x), (float)y, paint);
    }

    private Paint.Align convertGravity(int gravity) {
        if ((gravity & 0x800007 & 0x800003) == 0x800003) {
            return Paint.Align.LEFT;
        }
        if ((gravity & 0x800007 & 0x800005) == 0x800005) {
            return Paint.Align.RIGHT;
        }
        return Paint.Align.CENTER;
    }

    private float getAdjustedX(float x) {
        switch (this.textAlignment) {
            case LEFT: {
                return x + (float)this.padding + (float)this.margin;
            }
            case RIGHT: {
                return x + (float)this.widthPx - (float)this.padding - (float)this.margin;
            }
            case CENTER: {
                return x + (float)this.padding + (float)this.margin + (float)this.widthPx * 0.5f;
            }
        }
        return 0.0f;
    }
}

