/*
 * Decompiled with CFR 0.152.
 */
package com.raybritton.htmltableparser;

import android.text.Html;
import android.text.SpannableStringBuilder;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import com.raybritton.htmltableparser.TableColumnSpan;
import com.raybritton.htmltableparser.models.Cell;
import com.raybritton.htmltableparser.models.Row;
import com.raybritton.htmltableparser.models.Table;

public class CharSequenceConverter {
    private static final int DEFAULT = -1;
    private SparseIntArray htmlWidths = new SparseIntArray();

    public CharSequence makeCharSequence(TextView view, Table table) {
        view.setLineSpacing(0.0f, 1.2f);
        int viewWidth = view.getWidth();
        SpannableStringBuilder builder = new SpannableStringBuilder();
        this.htmlWidths.clear();
        for (int rowIdx = 0; rowIdx < table.getRowCount(); ++rowIdx) {
            for (int cellIdx = 0; cellIdx < table.getRow(rowIdx).getCellCount(); ++cellIdx) {
                Cell cell = table.getRow(rowIdx).getCell(cellIdx);
                int width = -1;
                int padding = (int)TypedValue.applyDimension((int)1, (float)cell.getPaddingDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
                int margin = (int)TypedValue.applyDimension((int)1, (float)cell.getMarginDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
                if (cell.getWidthDp() >= 0) {
                    width = (int)TypedValue.applyDimension((int)1, (float)cell.getWidthDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
                } else if (cell.getWidthPerc() >= 0.0f) {
                    width = (int)((float)viewWidth * cell.getWidthPerc());
                }
                width = width < 1 ? (int)view.getPaint().measureText(cell.getText()) + padding + padding + margin + margin : (width += padding + padding + margin + margin);
                if (this.htmlWidths.indexOfKey(cellIdx) >= 0 && this.htmlWidths.get(cellIdx, 0) >= width) continue;
                this.htmlWidths.put(cellIdx, width);
            }
        }
        if (table.getHeader() != null) {
            this.parseRow((View)view, builder, table.getHeader());
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            this.parseRow((View)view, builder, table.getRow(i));
        }
        if (table.getFooter() != null) {
            this.parseRow((View)view, builder, table.getFooter());
        }
        return builder;
    }

    private void parseRow(View view, SpannableStringBuilder builder, Row row) {
        for (int j = 0; j < row.getCellCount(); ++j) {
            Cell cell = row.getCell(j);
            int start = builder.length();
            builder.append((CharSequence)Html.fromHtml((String)cell.getText()));
            int end = builder.length();
            int padding = (int)TypedValue.applyDimension((int)1, (float)cell.getPaddingDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
            int margin = (int)TypedValue.applyDimension((int)1, (float)cell.getMarginDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
            builder.setSpan((Object)new TableColumnSpan(this.htmlWidths.get(j), padding, margin, cell), start, end, 17);
        }
        builder.append((CharSequence)"\n");
    }
}

