package com.raybritton.htmltableparser.models;

import android.graphics.Color;

import com.raybritton.htmltableparser.ImmutableList;

public class Row {
    private final ImmutableList<Cell> cells;
    private int backgroundColor = Color.TRANSPARENT;

    public Row(final ImmutableList<Cell> cells) {
        this.cells = cells;
    }

    public int getCellCount() {
        return cells.size();
    }

    public Cell getCell(int index) {
        return cells.get(index);
    }

    public int getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(final int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ImmutableList<Cell> getCells() {
        return cells;
    }
}
