package com.raybritton.htmltableparser;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;
import android.view.Gravity;

import com.raybritton.htmltableparser.models.Cell;

public class TableColumnSpan extends ReplacementSpan {

    private final int widthPx;
    private final int padding;
    private final int margin;
    private final Paint backgroundPaint;
    private final boolean isBold;
    private final Paint.Align textAlignment;

    public TableColumnSpan(int widthPx, int padding, int margin, Cell cell) {
        this.widthPx = widthPx;
        this.padding = padding;
        this.margin = margin;
        backgroundPaint = new Paint();
        backgroundPaint.setColor(cell.getBackgroundColor());
        backgroundPaint.setStyle(Paint.Style.FILL);
        isBold = cell.isBold();
        textAlignment = convertGravity(cell.getGravity());
    }

    @Override
    public int getSize(final Paint paint, final CharSequence text, final int start, final int end, final Paint.FontMetricsInt fm) {
        return widthPx;
    }

    @Override
    public void draw(final Canvas canvas, final CharSequence text, final int start, final int end, final float x, final int top, final int y, final int bottom, final Paint paint) {
        canvas.drawRect(x + margin, top, x + widthPx + margin, bottom, backgroundPaint);
        paint.setFakeBoldText(isBold);
        paint.setTextAlign(textAlignment);
        canvas.drawText(text, start, end, getAdjustedX(x), y, paint);
    }

    private Paint.Align convertGravity(int gravity) {
        if ((gravity & Gravity.RELATIVE_HORIZONTAL_GRAVITY_MASK & Gravity.START) == Gravity.START) {
            return Paint.Align.LEFT;
        } else if ((gravity & Gravity.RELATIVE_HORIZONTAL_GRAVITY_MASK  & Gravity.END) == Gravity.END) {
            return Paint.Align.RIGHT;
        } else {
            return Paint.Align.CENTER;
        }
    }

    private float getAdjustedX(float x) {
        switch (textAlignment) {
            case LEFT:
                return x + padding + margin;
            case RIGHT:
                return x + widthPx - padding - margin;
            case CENTER:
                return x + padding + margin + widthPx * 0.5f;
        }
        return 0;
    }
}
