/*
 * Decompiled with CFR 0.152.
 */
package com.raybritton.htmltableparser;

import android.graphics.Color;
import android.util.Log;
import com.raybritton.htmltableparser.ImmutableList;
import com.raybritton.htmltableparser.models.Cell;
import com.raybritton.htmltableparser.models.Row;
import com.raybritton.htmltableparser.models.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlTableParser {
    public static List<Table> parse(String html) {
        ArrayList<Table> tables = new ArrayList<Table>();
        Document document = Jsoup.parse((String)html);
        Elements tableElements = document.select("table");
        for (Element table : tableElements) {
            tables.add(HtmlTableParser.parse(table));
        }
        return tables;
    }

    private static Table parse(Element element) {
        Row header = null;
        Row footer = null;
        ArrayList<Row> body = new ArrayList<Row>();
        Elements headerElement = element.getElementsByTag("thead");
        Elements footerElement = element.getElementsByTag("tfoot");
        Elements bodyElement = element.getElementsByTag("tbody");
        Integer cellPadding = null;
        Integer cellMargin = null;
        if (element.hasAttr("cellpadding")) {
            cellPadding = Integer.parseInt(element.attr("cellpadding"));
        }
        if (element.hasAttr("cellmargin")) {
            cellMargin = Integer.parseInt(element.attr("cellmargin"));
        }
        if (headerElement != null && !headerElement.isEmpty()) {
            header = HtmlTableParser.parseRow(headerElement.first(), element, cellPadding, cellMargin);
            headerElement.remove();
        }
        if (footerElement != null && !footerElement.isEmpty()) {
            footer = HtmlTableParser.parseRow(footerElement.first(), element, cellPadding, cellMargin);
            footerElement.remove();
        }
        Elements rows = bodyElement != null && !bodyElement.isEmpty() ? bodyElement.first().getElementsByTag("tr") : element.getElementsByTag("tr");
        for (Element row : rows) {
            body.add(HtmlTableParser.parseRow(row, element, cellPadding, cellMargin));
        }
        return new Table(new ImmutableList<Row>((Collection<Row>)body), header, footer);
    }

    private static Row parseRow(Element rowElement, Element tableElement, Integer cellPadding, Integer cellMargin) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        Elements cellElements = rowElement.select("td, th");
        for (Element element : cellElements) {
            cells.add(HtmlTableParser.parseCell(element, rowElement, cellPadding, cellMargin));
        }
        Row row = new Row(new ImmutableList<Cell>((Collection<Cell>)cells));
        if (rowElement.hasAttr("bgcolor")) {
            row.setBackgroundColor(Color.parseColor((String)rowElement.attr("bgcolor")));
        }
        return row;
    }

    private static Cell parseCell(Element cellElement, Element rowElement, Integer cellPadding, Integer cellMargin) {
        Cell cell = new Cell(cellElement.text());
        int vertAlign = 16;
        int horzAlign = 0x800003;
        if (cellElement.tagName().equals("th")) {
            cell.setBold(true);
            horzAlign = 1;
        }
        if (cellElement.hasAttr("bgcolor")) {
            try {
                cell.setBackgroundColor(Color.parseColor((String)cellElement.attr("bgcolor")));
            }
            catch (IllegalArgumentException e) {
                cell.setBackgroundColor(0);
                Log.e((String)"PARSER", (String)("Unsupported colour: " + cellElement.attr("bgcolor")));
            }
        }
        if (cellPadding != null) {
            cell.setPaddingDp(cellPadding);
        }
        if (cellMargin != null) {
            cell.setMarginDp(cellMargin);
        }
        if (cellElement.hasAttr("width")) {
            String value = cellElement.attr("width");
            if (value.endsWith("%")) {
                value = value.substring(0, value.length() - 1);
                cell.setWidthPerc((float)Integer.parseInt(value) / 100.0f);
            } else {
                cell.setWidthDp(Integer.parseInt(cellElement.attr("width")));
            }
        }
        if (cellElement.hasAttr("align")) {
            switch (cellElement.attr("align")) {
                case "left": {
                    horzAlign = 0x800003;
                    break;
                }
                case "right": {
                    horzAlign = 0x800005;
                    break;
                }
                case "center": 
                case "justify": {
                    horzAlign = 1;
                }
            }
        }
        if (cellElement.hasAttr("valign")) {
            switch (cellElement.attr("valign")) {
                case "top": {
                    vertAlign = 48;
                    break;
                }
                case "middle": {
                    vertAlign = 16;
                    break;
                }
                case "bottom": {
                    vertAlign = 80;
                }
            }
        }
        cell.setGravity(vertAlign | horzAlign);
        return cell;
    }
}

