package com.raybritton.htmltableparser;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;

public class TableColumnSpan extends ReplacementSpan {

    private final int widthPx;
    private final int padding;
    private final int margin;
    private final Paint backgroundPaint;

    public TableColumnSpan(int widthPx, int padding, int margin, int bgColor) {
        this.widthPx = widthPx;
        this.padding = padding;
        this.margin = margin;
        backgroundPaint = new Paint();
        backgroundPaint.setColor(bgColor);
        backgroundPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public int getSize(final Paint paint, final CharSequence text, final int start, final int end, final Paint.FontMetricsInt fm) {
        return widthPx;
    }

    @Override
    public void draw(final Canvas canvas, final CharSequence text, final int start, final int end, final float x, final int top, final int y, final int bottom, final Paint paint) {
        canvas.drawRect(x + margin, top, x + widthPx + margin, bottom, backgroundPaint);
        canvas.drawText(text, start, end, x + padding + margin, y, paint);
    }
}
