/*
 * Decompiled with CFR 0.152.
 */
package com.raybritton.htmltableparser;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.raybritton.htmltableparser.models.Cell;
import com.raybritton.htmltableparser.models.Row;
import com.raybritton.htmltableparser.models.Table;

public class TableLayoutConverter {
    private final Context ctx;
    private final int ROW_PADDING;

    public TableLayoutConverter(Context ctx) {
        this.ctx = ctx;
        this.ROW_PADDING = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)ctx.getResources().getDisplayMetrics());
    }

    public TableLayout makeTableLayout(Table table) {
        TableLayout tableLayout = new TableLayout(this.ctx);
        tableLayout.setBackgroundColor(table.getBackgroundColor());
        tableLayout.setPadding(this.ROW_PADDING, this.ROW_PADDING, this.ROW_PADDING, this.ROW_PADDING);
        if (table.getHeader() != null) {
            tableLayout.addView((View)this.makeRow(table.getHeader()));
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            TableRow tableRow = this.makeRow(table.getRow(i));
            tableLayout.addView((View)tableRow);
        }
        if (table.getFooter() != null) {
            tableLayout.addView((View)this.makeRow(table.getFooter()));
        }
        return tableLayout;
    }

    private TableRow makeRow(Row row) {
        TableRow tableRow = new TableRow(this.ctx);
        tableRow.setBackgroundColor(row.getBackgroundColor());
        for (int i = 0; i < row.getCellCount(); ++i) {
            Cell cell = row.getCell(i);
            int padding = (int)TypedValue.applyDimension((int)1, (float)row.getCell(i).getPaddingDp(), (DisplayMetrics)this.ctx.getResources().getDisplayMetrics());
            int margin = (int)TypedValue.applyDimension((int)1, (float)row.getCell(i).getMarginDp(), (DisplayMetrics)this.ctx.getResources().getDisplayMetrics());
            TextView textView = new TextView(this.ctx);
            textView.setText((CharSequence)cell.getText());
            textView.setPadding(padding, padding, padding, padding);
            textView.setBackgroundColor(cell.getBackgroundColor());
            textView.getPaint().setFakeBoldText(cell.isBold());
            textView.setGravity(cell.getGravity());
            if (cell.getWidthDp() >= 0) {
                int width = (int)TypedValue.applyDimension((int)1, (float)cell.getWidthDp(), (DisplayMetrics)this.ctx.getResources().getDisplayMetrics());
                TableRow.LayoutParams params = new TableRow.LayoutParams(width, -2);
                params.bottomMargin = margin;
                params.topMargin = margin;
                params.leftMargin = margin;
                params.rightMargin = margin;
                textView.setLayoutParams((ViewGroup.LayoutParams)params);
            } else if (cell.getWidthPerc() >= 0.0f) {
                TableRow.LayoutParams params = new TableRow.LayoutParams(0, -2, cell.getWidthPerc());
                params.bottomMargin = margin;
                params.topMargin = margin;
                params.leftMargin = margin;
                params.rightMargin = margin;
                textView.setLayoutParams((ViewGroup.LayoutParams)params);
            } else {
                TableRow.LayoutParams params = new TableRow.LayoutParams(-2, -2);
                params.bottomMargin = margin;
                params.topMargin = margin;
                params.leftMargin = margin;
                params.rightMargin = margin;
                textView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            tableRow.addView((View)textView);
        }
        return tableRow;
    }
}

