/*
 * Decompiled with CFR 0.152.
 */
package com.raybritton.htmltableparser;

import android.text.SpannableStringBuilder;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.widget.TextView;
import com.raybritton.htmltableparser.TableColumnSpan;
import com.raybritton.htmltableparser.models.Cell;
import com.raybritton.htmltableparser.models.Table;

public class CharSequenceConverter {
    public CharSequence makeCharSequence(TextView view, Table table) {
        Cell cell;
        int j;
        int i;
        int viewWidth = view.getWidth();
        SpannableStringBuilder builder = new SpannableStringBuilder();
        SparseIntArray widths = new SparseIntArray();
        for (i = 0; i < table.getRowCount(); ++i) {
            for (j = 0; j < table.getRow(i).getCellCount(); ++j) {
                cell = table.getRow(i).getCell(j);
                int width = 0;
                if (cell.getWidthDp() >= 0) {
                    width = (int)TypedValue.applyDimension((int)1, (float)cell.getWidthDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
                } else if (cell.getWidthPerc() >= 0.0f) {
                    width = (int)((float)viewWidth * cell.getWidthPerc());
                }
                if (width == 0) {
                    width = (int)view.getPaint().measureText(cell.getText());
                }
                if (widths.get(j, 0) >= width) continue;
                widths.put(j, width);
            }
        }
        for (i = 0; i < table.getRowCount(); ++i) {
            for (j = 0; j < table.getRow(i).getCellCount(); ++j) {
                cell = table.getRow(i).getCell(j);
                int start = builder.length();
                builder.append((CharSequence)cell.getText());
                int end = builder.length();
                int padding = (int)TypedValue.applyDimension((int)1, (float)cell.getPaddingDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
                int margin = (int)TypedValue.applyDimension((int)1, (float)cell.getMarginDp(), (DisplayMetrics)view.getResources().getDisplayMetrics());
                builder.setSpan((Object)new TableColumnSpan(widths.get(j), padding, margin, cell.getBackgroundColor()), start, end, 17);
            }
            builder.append((CharSequence)"\n");
        }
        return builder;
    }
}

