package com.raybritton.htmltableparser.models;

import android.graphics.Color;
import android.view.Gravity;

public class Cell {
    private static final int HTML_MARGIN_OFFSET = 2;

    private final String contents;

    private int paddingDp = 0;
    private int marginDp = 0;
    private int backgroundColor = Color.TRANSPARENT;
    private boolean bold = false;
    private int widthDp = -1;
    private float widthPerc = -1;
    private int gravity = Gravity.START|Gravity.CENTER_VERTICAL;

    public Cell(final String contents) {
        this.contents = contents;
    }

    public String getText() {
        return contents;
    }

    public int getPaddingDp() {
        return paddingDp;
    }

    public void setPaddingDp(final int paddingDp) {
        this.paddingDp = paddingDp;
    }

    public int getMarginDp() {
        return marginDp + HTML_MARGIN_OFFSET;
    }

    public void setMarginDp(final int marginDp) {
        this.marginDp = marginDp;
    }

    public int getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(final int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getWidthDp() {
        return widthDp;
    }

    public void setWidthDp(final int widthDp) {
        this.widthDp = widthDp;
    }

    public float getWidthPerc() {
        return widthPerc;
    }

    public void setWidthPerc(final float widthPerc) {
        this.widthPerc = widthPerc;
    }

    public int getGravity() {
        return gravity;
    }

    public void setGravity(final int gravity) {
        this.gravity = gravity;
    }

    public boolean isBold() {
        return bold;
    }

    public void setBold(final boolean bold) {
        this.bold = bold;
    }
}
