package com.raybritton.htmltableparser;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.widget.TextView;

import com.raybritton.htmltableparser.models.Cell;
import com.raybritton.htmltableparser.models.Table;

public class CharSequenceConverter {

    public CharSequence makeCharSequence(TextView view, Table table) {
        int viewWidth = view.getWidth();
        SpannableStringBuilder builder = new SpannableStringBuilder();

        SparseIntArray widths = new SparseIntArray();

        for (int i = 0; i < table.getRowCount(); i++) {
            for (int j = 0; j < table.getRow(i).getCellCount(); j++) {
                Cell cell = table.getRow(i).getCell(j);
                int width = 0;
                if (cell.getWidthDp() >= 0) {
                    width = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, cell.getWidthDp(), view.getResources().getDisplayMetrics());
                } else if (cell.getWidthPerc() >= 0) {
                    width = (int) (viewWidth * cell.getWidthPerc());
                }
                if (width == 0) {
                    width = (int) view.getPaint().measureText(cell.getText());
                }
                if (widths.get(j, 0) < width) {
                    widths.put(j, width);
                }
            }
        }

        for (int i = 0; i < table.getRowCount(); i++) {
            for (int j = 0; j < table.getRow(i).getCellCount(); j++) {
                Cell cell = table.getRow(i).getCell(j);
                int start = builder.length();
                builder.append(cell.getText());
                int end = builder.length();

                int padding = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, cell.getPaddingDp(), view.getResources().getDisplayMetrics());
                int margin = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, cell.getMarginDp(), view.getResources().getDisplayMetrics());

                builder.setSpan(new TableColumnSpan(widths.get(j), padding, margin, cell.getBackgroundColor()), start, end, Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
            }
            builder.append("\n");
        }

        return builder;
    }
}
