package com.raybritton.htmltableparser.models;

import android.graphics.Color;

import java.util.List;

public class Table {
    private final List<Row> rows;
    private final Row header;
    private final Row footer;

    private int backgroundColor = Color.TRANSPARENT;

    public Table(final List<Row> rows, final Row header, final Row footer) {
        this.rows = rows;
        this.header = header;
        this.footer = footer;
    }

    public int getRowCount() {
        return rows.size();
    }

    public Row getRow(int index) {
        return rows.get(index);
    }

    public Row getFooter() {
        return footer;
    }

    public Row getHeader() {
        return header;
    }

    public int getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(final int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}
