package com.raybritton.htmltableparser;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;

public class TableColumnSpan extends ReplacementSpan {

    private final int width;
    private final int padding;
    private final Paint backgroundPaint;

    public TableColumnSpan(int width, int padding, int bgColor) {
        this.width = width;
        this.padding = padding;
        backgroundPaint = new Paint();
        backgroundPaint.setColor(bgColor);
        backgroundPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public int getSize(final Paint paint, final CharSequence text, final int start, final int end, final Paint.FontMetricsInt fm) {
        return width + padding + padding;
    }

    @Override
    public void draw(final Canvas canvas, final CharSequence text, final int start, final int end, final float x, final int top, final int y, final int bottom, final Paint paint) {
        canvas.drawRect(x, top, x + width, bottom, backgroundPaint);
        canvas.drawText(text, start, end, x + padding, y, paint);
    }
}
