/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.transport.exceptions;

import com.rapid7.client.dcerpc.PDUFault;
import com.rapid7.client.dcerpc.io.PacketInput;
import java.io.EOFException;
import java.io.IOException;

public class RPCFaultException
extends IOException {
    private final int rpcFaultValue;
    private final PDUFault rpcFault;

    public static RPCFaultException read(PacketInput in) throws IOException {
        int rpcFaultValue;
        try {
            rpcFaultValue = in.readInt();
        }
        catch (EOFException e) {
            rpcFaultValue = -1;
        }
        return new RPCFaultException(rpcFaultValue);
    }

    public RPCFaultException(int rpcFaultValue) {
        this.rpcFaultValue = rpcFaultValue;
        this.rpcFault = PDUFault.fromValue(this.rpcFaultValue);
    }

    public int getRpcFaultValue() {
        return this.rpcFaultValue;
    }

    public PDUFault getRpcFault() {
        return this.rpcFault;
    }

    @Override
    public String getMessage() {
        return String.format("Fault: %s (0x%08X)", new Object[]{this.getRpcFault(), this.getRpcFaultValue()});
    }
}

