/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Marshallable;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Arrays;

public class RPCShortBlob
implements Marshallable,
Unmarshallable {
    private int[] buffer;

    public int[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public void marshalPreamble(PacketOutput out) throws IOException {
    }

    @Override
    public void marshalEntity(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        if (this.buffer == null) {
            out.writeShort(0);
            out.writeShort(0);
            out.writeNull();
        } else {
            out.writeShort(this.buffer.length);
            out.writeShort(this.buffer.length);
            out.writeReferentID();
        }
    }

    @Override
    public void marshalDeferrals(PacketOutput out) throws IOException {
        if (this.buffer != null) {
            out.align(Alignment.FOUR);
            out.writeInt(this.buffer.length);
            out.writeInt(0);
            out.writeInt(this.buffer.length);
            for (int s : this.buffer) {
                out.writeShort(s);
            }
        }
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int length = in.readUnsignedShort();
        in.fullySkipBytes(2);
        if (in.readReferentID() != 0) {
            this.buffer = new int[length];
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.buffer != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            int offset = this.readIndex("Offset", in);
            int actualCount = this.readIndex("ActualCount", in);
            if (actualCount != this.buffer.length) {
                throw new UnmarshalException(String.format("Expected Length == Buffer.ActualCount: %d != %d", actualCount, this.buffer.length));
            }
            in.fullySkipBytes(2 * offset);
            for (int i = 0; i < actualCount; ++i) {
                this.buffer[i] = in.readUnsignedShort();
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBuffer());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RPCShortBlob)) {
            return false;
        }
        return Arrays.equals(this.getBuffer(), ((RPCShortBlob)obj).getBuffer());
    }

    public String toString() {
        return String.format("RPC_SHORT_BLOB{size(Buffer):%s}", this.buffer == null ? "null" : Integer.valueOf(this.buffer.length));
    }

    private int readIndex(String name, PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }
}

