/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Marshallable;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.MarshalException;
import java.util.Arrays;
import java.util.Objects;

public class RPCSID
implements Unmarshallable,
Marshallable {
    private char revision;
    private char subAuthorityCount;
    private byte[] identifierAuthority;
    private long[] subAuthority;

    public char getRevision() {
        return this.revision;
    }

    public void setRevision(char revision) {
        this.revision = revision;
    }

    public char getSubAuthorityCount() {
        return this.subAuthorityCount;
    }

    public byte[] getIdentifierAuthority() {
        return this.identifierAuthority;
    }

    public void setIdentifierAuthority(byte[] identifierAuthority) {
        this.identifierAuthority = identifierAuthority;
    }

    public long[] getSubAuthority() {
        return this.subAuthority;
    }

    public void setSubAuthority(long[] subAuthority) {
        this.subAuthority = subAuthority;
        this.subAuthorityCount = (char)subAuthority.length;
    }

    @Override
    public void marshalPreamble(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        out.writeInt(this.subAuthority.length);
    }

    @Override
    public void marshalEntity(PacketOutput out) throws IOException {
        if (this.subAuthorityCount != this.subAuthority.length) {
            throw new MarshalException(String.format("SubAuthorityCount (%d) != SubAuthority[] length (%d)", this.subAuthorityCount, this.subAuthority.length));
        }
        out.align(Alignment.FOUR);
        out.writeByte(this.revision);
        out.writeByte(this.subAuthorityCount);
        out.write(this.identifierAuthority, 0, 6);
        for (long subAuthority : this.subAuthority) {
            out.writeInt((int)subAuthority);
        }
    }

    @Override
    public void marshalDeferrals(PacketOutput out) throws IOException {
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        in.fullySkipBytes(4);
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        this.revision = in.readUnsignedByte();
        this.subAuthorityCount = in.readUnsignedByte();
        this.identifierAuthority = new byte[6];
        in.readRawBytes(this.identifierAuthority);
        this.subAuthority = new long[this.subAuthorityCount];
        for (int i = 0; i < this.subAuthority.length; ++i) {
            this.subAuthority[i] = in.readUnsignedInt();
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
    }

    public int hashCode() {
        int result = Objects.hash(Character.valueOf(this.getRevision()), Character.valueOf(this.getSubAuthorityCount()));
        result = 31 * result + Arrays.hashCode(this.getIdentifierAuthority());
        result = 31 * result + Arrays.hashCode(this.getSubAuthority());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RPCSID)) {
            return false;
        }
        RPCSID other = (RPCSID)obj;
        return this.getRevision() == other.getRevision() && this.getSubAuthorityCount() == other.getSubAuthorityCount() && Arrays.equals(this.getIdentifierAuthority(), other.getIdentifierAuthority()) && Arrays.equals(this.getSubAuthority(), other.getSubAuthority());
    }

    public String toString() {
        return String.format("RPC_SID{Revision:%d, SubAuthorityCount:%d, IdentifierAuthority:%s, SubAuthority: %s}", this.getRevision(), (int)this.getSubAuthorityCount(), Arrays.toString(this.getIdentifierAuthority()), Arrays.toString(this.getSubAuthority()));
    }
}

