/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msvcctl.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.objects.WChar;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class LPQueryServiceConfigW
implements Unmarshallable {
    private static final String[] EMPTY_DEPENDENCIES = new String[0];
    private int dwServiceType;
    private int dwStartType;
    private int dwErrorControl;
    private WChar.NullTerminated lpBinaryPathName;
    private WChar.NullTerminated lpLoadOrderGroup;
    private int dwTagId;
    private String[] lpDependencies;
    private WChar.NullTerminated lpServiceStartName;
    private WChar.NullTerminated lpDisplayName;

    public int getDwServiceType() {
        return this.dwServiceType;
    }

    public void setDwServiceType(int dwServiceType) {
        this.dwServiceType = dwServiceType;
    }

    public int getDwStartType() {
        return this.dwStartType;
    }

    public void setDwStartType(int dwStartType) {
        this.dwStartType = dwStartType;
    }

    public int getDwErrorControl() {
        return this.dwErrorControl;
    }

    public void setDwErrorControl(int dwErrorControl) {
        this.dwErrorControl = dwErrorControl;
    }

    public WChar.NullTerminated getLpBinaryPathName() {
        return this.lpBinaryPathName;
    }

    public void setLpBinaryPathName(WChar.NullTerminated lpBinaryPathName) {
        this.lpBinaryPathName = lpBinaryPathName;
    }

    public WChar.NullTerminated getLpLoadOrderGroup() {
        return this.lpLoadOrderGroup;
    }

    public void setLpLoadOrderGroup(WChar.NullTerminated lpLoadOrderGroup) {
        this.lpLoadOrderGroup = lpLoadOrderGroup;
    }

    public int getDwTagId() {
        return this.dwTagId;
    }

    public void setDwTagId(int dwTagId) {
        this.dwTagId = dwTagId;
    }

    public String[] getLpDependencies() {
        return this.lpDependencies;
    }

    public void setLpDependencies(String[] lpDependencies) {
        this.lpDependencies = lpDependencies;
    }

    public WChar.NullTerminated getLpServiceStartName() {
        return this.lpServiceStartName;
    }

    public void setLpServiceStartName(WChar.NullTerminated lpServiceStartName) {
        this.lpServiceStartName = lpServiceStartName;
    }

    public WChar.NullTerminated getLpDisplayName() {
        return this.lpDisplayName;
    }

    public void setLpDisplayName(WChar.NullTerminated lpDisplayName) {
        this.lpDisplayName = lpDisplayName;
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        this.dwServiceType = in.readInt();
        this.dwStartType = in.readInt();
        this.dwErrorControl = in.readInt();
        this.lpBinaryPathName = in.readReferentID() != 0 ? new WChar.NullTerminated() : null;
        this.lpLoadOrderGroup = in.readReferentID() != 0 ? new WChar.NullTerminated() : null;
        this.dwTagId = in.readInt();
        this.lpDependencies = in.readReferentID() != 0 ? EMPTY_DEPENDENCIES : null;
        this.lpServiceStartName = in.readReferentID() != 0 ? new WChar.NullTerminated() : null;
        this.lpDisplayName = in.readReferentID() != 0 ? new WChar.NullTerminated() : null;
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.lpBinaryPathName != null) {
            in.readUnmarshallable(this.lpBinaryPathName);
        }
        if (this.lpLoadOrderGroup != null) {
            in.readUnmarshallable(this.lpLoadOrderGroup);
        }
        if (this.lpDependencies != null) {
            WChar.NullTerminated lpDependency = new WChar.NullTerminated();
            in.readUnmarshallable(lpDependency);
            this.lpDependencies = lpDependency.getValue().split("/");
        }
        if (this.lpServiceStartName != null) {
            in.readUnmarshallable(this.lpServiceStartName);
        }
        if (this.lpDisplayName != null) {
            in.readUnmarshallable(this.lpDisplayName);
        }
    }

    public int hashCode() {
        int ret = Objects.hash(this.getDwServiceType(), this.getDwStartType(), this.getDwErrorControl(), this.getLpBinaryPathName(), this.getLpLoadOrderGroup(), this.getDwTagId(), this.getLpServiceStartName(), this.getLpDisplayName());
        return ret * 31 + Arrays.hashCode(this.getLpDependencies());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LPQueryServiceConfigW)) {
            return false;
        }
        LPQueryServiceConfigW other = (LPQueryServiceConfigW)obj;
        return this.getDwServiceType() == other.getDwServiceType() && this.getDwStartType() == other.getDwStartType() && this.getDwErrorControl() == other.getDwErrorControl() && Objects.equals(this.getLpBinaryPathName(), other.getLpBinaryPathName()) && Objects.equals(this.getLpLoadOrderGroup(), other.getLpLoadOrderGroup()) && this.getDwTagId() == other.getDwTagId() && Arrays.equals(this.getLpDependencies(), other.getLpDependencies()) && Objects.equals(this.getLpServiceStartName(), other.getLpServiceStartName()) && Objects.equals(this.getLpDisplayName(), other.getLpDisplayName());
    }

    public String toString() {
        return String.format("QUERY_SERVICE_CONFIGW{dwServiceType: %d, dwStartType: %d, dwErrorControl: %d, lpBinaryPathName: %s, lpLoadOrderGroup: %s, dwTagId: %d, lpDependencies: %s, lpServiceStartName: %s, lpDisplayName: %s}", this.getDwServiceType(), this.getDwStartType(), this.getDwErrorControl(), this.getLpBinaryPathName(), this.getLpLoadOrderGroup(), this.getDwTagId(), Arrays.toString(this.getLpDependencies()), this.getLpServiceStartName(), this.getLpDisplayName());
    }
}

