/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msvcctl.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.msvcctl.messages.RChangeServiceConfigWResponse;
import com.rapid7.client.dcerpc.objects.WChar;
import java.io.IOException;

public class RChangeServiceConfigWRequest
extends RequestCall<RChangeServiceConfigWResponse> {
    private static final short OP_NUM = 11;
    private final byte[] hService;
    private final int dwServiceType;
    private final int dwStartType;
    private final int dwErrorControl;
    private final WChar.NullTerminated lpBinaryPathName;
    private final WChar.NullTerminated lpLoadOrderGroup;
    private final Integer lpDwTagId;
    private final String[] lpDependencies;
    private final WChar.NullTerminated lpServiceStartName;
    private final String lpPassword;
    private final WChar.NullTerminated lpDisplayName;

    public RChangeServiceConfigWRequest(byte[] hService, int dwServiceType, int dwStartType, int dwErrorControl, WChar.NullTerminated lpBinaryPathName, WChar.NullTerminated lpLoadOrderGroup, Integer lpDwTagId, String[] lpDependencies, WChar.NullTerminated lpServiceStartName, String lpPassword, WChar.NullTerminated lpDisplayName) {
        super((short)11);
        this.hService = hService;
        this.dwServiceType = dwServiceType;
        this.dwStartType = dwStartType;
        this.dwErrorControl = dwErrorControl;
        this.lpBinaryPathName = lpBinaryPathName;
        this.lpLoadOrderGroup = lpLoadOrderGroup;
        this.lpDwTagId = lpDwTagId;
        this.lpDependencies = lpDependencies;
        this.lpServiceStartName = lpServiceStartName;
        this.lpPassword = lpPassword;
        this.lpDisplayName = lpDisplayName;
    }

    @Override
    public RChangeServiceConfigWResponse getResponseObject() {
        return new RChangeServiceConfigWResponse();
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        int byteCount;
        packetOut.write(this.hService);
        packetOut.writeInt(this.dwServiceType);
        packetOut.writeInt(this.dwStartType);
        packetOut.writeInt(this.dwErrorControl);
        if (packetOut.writeReferentID(this.lpBinaryPathName)) {
            packetOut.writeMarshallable(this.lpBinaryPathName);
            packetOut.align(Alignment.FOUR);
        }
        if (packetOut.writeReferentID(this.lpLoadOrderGroup)) {
            packetOut.writeMarshallable(this.lpLoadOrderGroup);
            packetOut.align(Alignment.FOUR);
        }
        if (this.lpDwTagId != null && this.lpDwTagId != 0) {
            packetOut.writeReferentID();
            packetOut.writeInt(this.lpDwTagId);
        } else {
            packetOut.writeNull();
        }
        if (packetOut.writeReferentID(this.lpDependencies)) {
            byteCount = 2;
            for (String dependency : this.lpDependencies) {
                byteCount += (dependency == null ? 0 : dependency.length() * 2) + 2;
            }
            packetOut.writeInt(byteCount);
            for (String dependency : this.lpDependencies) {
                if (dependency != null) {
                    for (int i = 0; i < dependency.length(); ++i) {
                        packetOut.writeChar(dependency.charAt(i));
                    }
                }
                packetOut.writeChar(0);
            }
            packetOut.writeChar(0);
            packetOut.align(Alignment.FOUR);
            packetOut.writeInt(byteCount);
        } else {
            packetOut.writeInt(0);
        }
        if (packetOut.writeReferentID(this.lpServiceStartName)) {
            packetOut.writeMarshallable(this.lpServiceStartName);
            packetOut.align(Alignment.FOUR);
        }
        if (packetOut.writeReferentID(this.lpPassword)) {
            byteCount = this.lpPassword.length() * 2 + 2;
            packetOut.writeInt(byteCount);
            for (int i = 0; i < this.lpPassword.length(); ++i) {
                packetOut.writeChar(this.lpPassword.charAt(i));
            }
            packetOut.writeChar(0);
            packetOut.align(Alignment.FOUR);
            packetOut.writeInt(byteCount);
        } else {
            packetOut.writeInt(0);
        }
        if (packetOut.writeReferentID(this.lpDisplayName)) {
            packetOut.writeMarshallable(this.lpDisplayName);
        }
    }
}

