/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo0;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo1;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo2;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo501;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo502;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo503;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfoLevel;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class NetrShareGetInfoResponse<T extends ShareInfo>
extends RequestResponse {
    private T shareInfo;

    public T getShareInfo() {
        return this.shareInfo;
    }

    public abstract ShareInfoLevel getShareInfoLevel();

    abstract T createShareInfo();

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        int infoLevel = packetIn.readInt();
        if (infoLevel != this.getShareInfoLevel().getInfoLevel()) {
            throw new UnmarshalException(String.format("Incoming LPSHARE_INFO level %d does not match expected: %d", infoLevel, this.getShareInfoLevel().getInfoLevel()));
        }
        if (packetIn.readReferentID() != 0) {
            this.shareInfo = this.createShareInfo();
            packetIn.readUnmarshallable(this.shareInfo);
        } else {
            this.shareInfo = null;
        }
    }

    public static class NetrShareGetInfoResponse503
    extends NetrShareGetInfoResponse<ShareInfo503> {
        @Override
        public ShareInfoLevel getShareInfoLevel() {
            return ShareInfoLevel.LPSHARE_INFO_503;
        }

        @Override
        ShareInfo503 createShareInfo() {
            return new ShareInfo503();
        }
    }

    public static class NetrShareGetInfoResponse502
    extends NetrShareGetInfoResponse<ShareInfo502> {
        @Override
        public ShareInfoLevel getShareInfoLevel() {
            return ShareInfoLevel.LPSHARE_INFO_502;
        }

        @Override
        ShareInfo502 createShareInfo() {
            return new ShareInfo502();
        }
    }

    public static class NetrShareGetInfoResponse501
    extends NetrShareGetInfoResponse<ShareInfo501> {
        @Override
        public ShareInfoLevel getShareInfoLevel() {
            return ShareInfoLevel.LPSHARE_INFO_501;
        }

        @Override
        ShareInfo501 createShareInfo() {
            return new ShareInfo501();
        }
    }

    public static class NetrShareGetInfoResponse2
    extends NetrShareGetInfoResponse<ShareInfo2> {
        @Override
        public ShareInfoLevel getShareInfoLevel() {
            return ShareInfoLevel.LPSHARE_INFO_2;
        }

        @Override
        ShareInfo2 createShareInfo() {
            return new ShareInfo2();
        }
    }

    public static class NetrShareGetInfoResponse1
    extends NetrShareGetInfoResponse<ShareInfo1> {
        @Override
        public ShareInfoLevel getShareInfoLevel() {
            return ShareInfoLevel.LPSHARE_INFO_1;
        }

        @Override
        ShareInfo1 createShareInfo() {
            return new ShareInfo1();
        }
    }

    public static class NetrShareGetInfoResponse0
    extends NetrShareGetInfoResponse<ShareInfo0> {
        @Override
        public ShareInfoLevel getShareInfoLevel() {
            return ShareInfoLevel.LPSHARE_INFO_0;
        }

        @Override
        ShareInfo0 createShareInfo() {
            return new ShareInfo0();
        }
    }
}

