/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Arrays;

public class SAMPRULongArray
implements Unmarshallable {
    private long[] array;

    public long[] getArray() {
        return this.array;
    }

    public void setArray(long[] array) {
        this.array = array;
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int count = this.readIndex("Count", in);
        this.array = (long[])(in.readReferentID() != 0 ? new long[count] : null);
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.array != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = in.readUnsignedInt();
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.getArray());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SAMPRULongArray)) {
            return false;
        }
        return Arrays.equals(this.getArray(), ((SAMPRULongArray)obj).getArray());
    }

    public String toString() {
        return String.format("SAMPR_ULONG_ARRAY{size(Element):%s", this.array == null ? "null" : Integer.valueOf(this.array.length));
    }

    private int readIndex(String name, PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }
}

