/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SAMPREnumerationBuffer<T extends Unmarshallable>
implements Unmarshallable {
    private int entriesRead;
    private List<T> array;

    public int getEntriesRead() {
        return this.entriesRead;
    }

    public List<T> getEntries() {
        if (this.array == null) {
            return null;
        }
        return Collections.unmodifiableList(this.array);
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        this.entriesRead = in.readInt();
        if (in.readReferentID() != 0) {
            this.array = this.entriesRead > 0 ? new ArrayList<T>(this.entriesRead) : Collections.emptyList();
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.array != null) {
            in.align(Alignment.FOUR);
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                Object t = this.initEntity();
                this.array.add(t);
                t.unmarshalPreamble(in);
            }
            for (Object t : this.array) {
                t.unmarshalEntity(in);
            }
            for (Object t : this.array) {
                t.unmarshalDeferrals(in);
            }
        }
    }

    protected abstract T initEntity() throws UnmarshalException;
}

