/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.mslsad.objects.DomainInformationClass;
import com.rapid7.client.dcerpc.mssamr.messages.SamrQueryInformationDomainResponse;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainLogoffInfo;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainPasswordInfo;
import java.io.IOException;

public abstract class SamrQueryInformationDomainRequest<T extends Unmarshallable>
extends RequestCall<SamrQueryInformationDomainResponse<T>> {
    public static final short OP_NUM = 8;
    private final byte[] domainHandle;

    public SamrQueryInformationDomainRequest(byte[] domainHandle) {
        super((short)8);
        this.domainHandle = domainHandle;
    }

    public byte[] getDomainHandle() {
        return this.domainHandle;
    }

    public abstract DomainInformationClass getDomainInformationClass();

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        packetOut.write(this.domainHandle);
        packetOut.writeShort(this.getDomainInformationClass().getInfoLevel());
    }

    public static class DomainLogOffInformation
    extends SamrQueryInformationDomainRequest<SAMPRDomainLogoffInfo> {
        public DomainLogOffInformation(byte[] domainHandle) {
            super(domainHandle);
        }

        @Override
        public DomainInformationClass getDomainInformationClass() {
            return DomainInformationClass.DOMAIN_LOGOFF_INFORMATION;
        }

        @Override
        public SamrQueryInformationDomainResponse.DomainLogOffInformation getResponseObject() {
            return new SamrQueryInformationDomainResponse.DomainLogOffInformation();
        }
    }

    public static class DomainPasswordInformation
    extends SamrQueryInformationDomainRequest<SAMPRDomainPasswordInfo> {
        public DomainPasswordInformation(byte[] domainHandle) {
            super(domainHandle);
        }

        @Override
        public DomainInformationClass getDomainInformationClass() {
            return DomainInformationClass.DOMAIN_PASSWORD_INFORMATION;
        }

        @Override
        public SamrQueryInformationDomainResponse.DomainPasswordInformation getResponseObject() {
            return new SamrQueryInformationDomainResponse.DomainPasswordInformation();
        }
    }
}

