/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.mssamr.messages.SamrLookupNamesInDomainResponse;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import java.io.IOException;

public class SamrLookupNamesInDomainRequest
extends RequestCall<SamrLookupNamesInDomainResponse> {
    public static final short OP_NUM = 17;
    private final byte[] domainHandle;
    private final RPCUnicodeString.NonNullTerminated[] names;

    public SamrLookupNamesInDomainRequest(byte[] domainHandle, RPCUnicodeString.NonNullTerminated[] names) {
        super((short)17);
        if (domainHandle == null) {
            throw new IllegalArgumentException("domainHandle must not be null");
        }
        if (names == null) {
            throw new IllegalArgumentException("names must not be null");
        }
        if (names.length > 1000) {
            throw new IllegalArgumentException(String.format("names must not contain more than 1000 elements, got: %d", names.length));
        }
        this.domainHandle = domainHandle;
        this.names = names;
    }

    public byte[] getDomainHandle() {
        return this.domainHandle;
    }

    public RPCUnicodeString.NonNullTerminated[] getNames() {
        return this.names;
    }

    @Override
    public SamrLookupNamesInDomainResponse getResponseObject() {
        return new SamrLookupNamesInDomainResponse();
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        packetOut.write(this.domainHandle);
        packetOut.writeInt(this.names.length);
        packetOut.writeInt(1000);
        packetOut.writeInt(0);
        packetOut.writeInt(this.names.length);
        for (RPCUnicodeString.NonNullTerminated name : this.names) {
            name.marshalPreamble(packetOut);
        }
        for (RPCUnicodeString.NonNullTerminated name : this.names) {
            name.marshalEntity(packetOut);
        }
        for (RPCUnicodeString.NonNullTerminated name : this.names) {
            name.marshalDeferrals(packetOut);
        }
    }
}

