/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.dto;

import java.util.Objects;

public class DomainPasswordInfo {
    private static final int DOMAIN_PASSWORD_COMPLEX = 1;
    private static final int DOMAIN_PASSWORD_NO_ANON_CHANGE = 2;
    private static final int DOMAIN_PASSWORD_STORE_CLEARTEXT = 16;
    private final int minimumPasswordLength;
    private final int passwordHistoryLength;
    private final int passwordProperties;
    private final long maximumPasswordAge;
    private final long minimumPasswordAge;

    public DomainPasswordInfo(int minimumPasswordLength, int passwordHistoryLength, int passwordProperties, long maximumPasswordAge, long minimumPasswordAge) {
        this.minimumPasswordLength = minimumPasswordLength;
        this.passwordHistoryLength = passwordHistoryLength;
        this.passwordProperties = passwordProperties;
        this.maximumPasswordAge = maximumPasswordAge;
        this.minimumPasswordAge = minimumPasswordAge;
    }

    public boolean isDomainPasswordComplex() {
        return (this.passwordProperties & 1) != 0;
    }

    public boolean isDomainPasswordNoAnonChange() {
        return (this.passwordProperties & 2) != 0;
    }

    public boolean isDomainPasswordStoredClearText() {
        return (this.passwordProperties & 0x10) != 0;
    }

    public int getMinimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    public int getPasswordHistoryLength() {
        return this.passwordHistoryLength;
    }

    public int getPasswordProperties() {
        return this.passwordProperties;
    }

    public long getMaximumPasswordAge() {
        return this.maximumPasswordAge;
    }

    public long getMinimumPasswordAge() {
        return this.minimumPasswordAge;
    }

    public int hashCode() {
        return Objects.hash(this.getMinimumPasswordLength(), this.getPasswordHistoryLength(), this.getPasswordProperties(), this.getMaximumPasswordAge(), this.getMinimumPasswordAge());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DomainPasswordInfo)) {
            return false;
        }
        DomainPasswordInfo other = (DomainPasswordInfo)obj;
        return Objects.equals(this.getMinimumPasswordLength(), other.getMinimumPasswordLength()) && Objects.equals(this.getPasswordHistoryLength(), other.getPasswordHistoryLength()) && Objects.equals(this.getPasswordProperties(), other.getPasswordProperties()) && Objects.equals(this.getMaximumPasswordAge(), other.getMaximumPasswordAge()) && Objects.equals(this.getMinimumPasswordAge(), other.getMinimumPasswordAge());
    }

    public String toString() {
        return String.format("DomainPasswordInformation{minimumPasswordLength: %d, passwordHistoryLength: %d, passwordProperties: %d, maximumPasswordAge: %d, minimumPasswordAge: %d, isDomainPasswordComplex: %b, isDomainPasswordNoAnonChange: %b, isDomainPasswordStoredClearText: %b}", this.getMinimumPasswordLength(), this.getPasswordHistoryLength(), this.getPasswordProperties(), this.getMaximumPasswordAge(), this.getMinimumPasswordAge(), this.isDomainPasswordComplex(), this.isDomainPasswordNoAnonChange(), this.isDomainPasswordStoredClearText());
    }
}

