/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import java.io.IOException;
import java.util.Objects;

public class LSAPRTranslatedName
implements Unmarshallable {
    private short use;
    private RPCUnicodeString.NonNullTerminated name;
    private int domainIndex;

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
        this.name = new RPCUnicodeString.NonNullTerminated();
        this.name.unmarshalPreamble(in);
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        this.use = in.readShort();
        in.fullySkipBytes(2);
        this.name.unmarshalEntity(in);
        in.align(Alignment.FOUR);
        this.domainIndex = in.readInt();
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        this.name.unmarshalDeferrals(in);
    }

    public int getUse() {
        return this.use;
    }

    public RPCUnicodeString getName() {
        return this.name;
    }

    public int getDomainIndex() {
        return this.domainIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSAPRTranslatedName)) {
            return false;
        }
        LSAPRTranslatedName other = (LSAPRTranslatedName)obj;
        return this.use == other.use && Objects.equals(this.name, other.name) && this.domainIndex == other.domainIndex;
    }

    public int hashCode() {
        return Objects.hash(this.use, this.name, this.domainIndex);
    }

    public String toString() {
        return String.format("LSAPR_TRANSLATED_NAME{Use:%d,Name:%s,DomainIndex:%d", this.use, this.name, this.domainIndex);
    }
}

