/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyAccountDomInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyAuditEventsInfo;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRPolicyPrimaryDomInfo;
import com.rapid7.client.dcerpc.mslsad.objects.PolicyInformationClass;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class LsarQueryInformationPolicyResponse<T extends Unmarshallable>
extends RequestResponse {
    private T policyInformation;

    public abstract PolicyInformationClass getPolicyInformationClass();

    abstract T createPolicyInformation();

    public T getPolicyInformation() {
        return this.policyInformation;
    }

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        if (packetIn.readReferentID() != 0) {
            int infoLevel = packetIn.readUnsignedShort();
            if (infoLevel != this.getPolicyInformationClass().getInfoLevel()) {
                throw new UnmarshalException(String.format("Incoming POLICY_INFORMATION_CLASS %d does not match expected: %d", infoLevel, this.getPolicyInformationClass().getInfoLevel()));
            }
            this.policyInformation = this.createPolicyInformation();
            packetIn.readUnmarshallable(this.policyInformation);
        } else {
            this.policyInformation = null;
        }
    }

    public static class PolicyAccountDomainInformation
    extends LsarQueryInformationPolicyResponse<LSAPRPolicyAccountDomInfo> {
        @Override
        public PolicyInformationClass getPolicyInformationClass() {
            return PolicyInformationClass.POLICY_ACCOUNT_DOMAIN_INFORMATION;
        }

        @Override
        LSAPRPolicyAccountDomInfo createPolicyInformation() {
            return new LSAPRPolicyAccountDomInfo();
        }
    }

    public static class PolicyPrimaryDomainInformation
    extends LsarQueryInformationPolicyResponse<LSAPRPolicyPrimaryDomInfo> {
        @Override
        public PolicyInformationClass getPolicyInformationClass() {
            return PolicyInformationClass.POLICY_PRIMARY_DOMAIN_INFORMATION;
        }

        @Override
        LSAPRPolicyPrimaryDomInfo createPolicyInformation() {
            return new LSAPRPolicyPrimaryDomInfo();
        }
    }

    public static class PolicyAuditEventsInformation
    extends LsarQueryInformationPolicyResponse<LSAPRPolicyAuditEventsInfo> {
        @Override
        public PolicyInformationClass getPolicyInformationClass() {
            return PolicyInformationClass.POLICY_AUDIT_EVENTS_INFORMATION;
        }

        @Override
        LSAPRPolicyAuditEventsInfo createPolicyInformation() {
            return new LSAPRPolicyAuditEventsInfo();
        }
    }
}

