/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.messages;

import com.rapid7.client.dcerpc.Header;
import com.rapid7.client.dcerpc.PDUType;
import com.rapid7.client.dcerpc.PFCFlag;
import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import java.io.IOException;
import java.util.Set;

public final class Request
extends Header {
    private short opNum;
    private byte[] stub;

    public Request() {
        this.setPDUType(PDUType.REQUEST);
    }

    public short getOpNum() {
        return this.opNum;
    }

    public byte[] getStub() {
        return this.stub;
    }

    public void setOpNum(short opNum) {
        this.opNum = opNum;
    }

    public void setStub(byte[] stub) {
        this.stub = stub;
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        if (null == this.getStub()) {
            throw new IllegalStateException("Invalid stub: " + this.getStub());
        }
        Set<PFCFlag> pfcFlags = this.getPFCFlags();
        this.setFragLength((short)((pfcFlags.contains((Object)PFCFlag.OBJECT_UUID) ? 40 : 24) + this.stub.length));
        super.marshal(packetOut);
        byte[] stub = this.getStub();
        packetOut.writeInt(stub.length);
        packetOut.writeShort(0);
        packetOut.writeShort(this.getOpNum());
        packetOut.write(stub);
    }

    @Override
    public void unmarshal(PacketInput packetIn) throws IOException {
        throw new UnsupportedOperationException("Unmarshal Not Implemented.");
    }
}

