/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.io;

import com.google.common.io.CountingInputStream;
import com.google.common.io.LittleEndianDataInputStream;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class PrimitiveInput {
    private final CountingInputStream dataInStream;
    private final DataInput dataIn;

    public PrimitiveInput(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid InputStream: null");
        }
        this.dataInStream = new CountingInputStream(inputStream);
        this.dataIn = new LittleEndianDataInputStream((InputStream)this.dataInStream);
    }

    public void align(Alignment alignment) throws IOException {
        if (alignment == Alignment.ONE) {
            return;
        }
        long readBytes = ((long)alignment.getOffByOneAlignment() + this.dataInStream.getCount() & (long)(~alignment.getOffByOneAlignment())) - this.dataInStream.getCount();
        while (readBytes-- > 0L) {
            this.readByte();
        }
    }

    public long getCount() {
        return this.dataInStream.getCount();
    }

    public void readFully(byte[] b) throws IOException {
        this.dataIn.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataIn.readFully(b, off, len);
    }

    public void fullySkipBytes(int n) throws IOException {
        if (n != this.dataIn.skipBytes(n)) {
            throw new EOFException();
        }
    }

    public boolean readBoolean() throws IOException {
        return this.dataIn.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    public char readUnsignedByte() throws IOException {
        return (char)this.dataIn.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dataIn.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataIn.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dataIn.readChar();
    }

    public int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws IOException {
        return this.dataIn.readLong();
    }

    public float readFloat() throws IOException {
        return this.dataIn.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dataIn.readDouble();
    }
}

