/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.io;

import com.rapid7.client.dcerpc.io.PrimitiveInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.UnmarshalException;

public class PacketInput
extends PrimitiveInput {
    public PacketInput(InputStream inputStream) {
        super(inputStream);
    }

    public <T extends Unmarshallable> T readUnmarshallable(T unmarshallable) throws IOException {
        unmarshallable.unmarshalPreamble(this);
        unmarshallable.unmarshalEntity(this);
        unmarshallable.unmarshalDeferrals(this);
        return unmarshallable;
    }

    public int readReferentID() throws IOException {
        return this.readInt();
    }

    public byte[] readRawBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readRawBytes(bytes);
        return bytes;
    }

    public void readRawBytes(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    public int readIndex(String name) throws IOException {
        long ret = this.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }
}

