/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.dto;

import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;

public class SID {
    private final byte revision;
    private final byte[] identifierAuthority;
    private final long[] subAuthorities;

    public SID(byte revision, byte[] identifierAuthority, long[] subAuthorities) {
        if (identifierAuthority == null) {
            throw new IllegalArgumentException("Expecting non-null identifierAuthority");
        }
        if (identifierAuthority.length != 6) {
            throw new IllegalArgumentException(String.format("Expected 6 entries in identifierAuthority, got: %d", identifierAuthority.length));
        }
        if (subAuthorities == null) {
            throw new IllegalArgumentException("Expecting non-null subAuthorities");
        }
        this.revision = revision;
        this.identifierAuthority = identifierAuthority;
        this.subAuthorities = subAuthorities;
    }

    public byte getRevision() {
        return this.revision;
    }

    public byte[] getIdentifierAuthority() {
        return this.identifierAuthority;
    }

    public long[] getSubAuthorities() {
        return this.subAuthorities;
    }

    public Long getRelativeID() {
        if (this.subAuthorities.length == 0) {
            return null;
        }
        return this.subAuthorities[this.subAuthorities.length - 1];
    }

    public SID resolveRelativeID(long relativeID) {
        byte[] identifierAuthority = Arrays.copyOf(this.identifierAuthority, this.identifierAuthority.length);
        long[] subAuthorities = Arrays.copyOf(this.subAuthorities, this.subAuthorities.length + 1);
        subAuthorities[subAuthorities.length - 1] = relativeID;
        return new SID(this.revision, identifierAuthority, subAuthorities);
    }

    public int hashCode() {
        int ret = Objects.hashCode(this.getRevision());
        ret = 31 * ret + Arrays.hashCode(this.getIdentifierAuthority());
        ret = 31 * ret + Arrays.hashCode(this.getSubAuthorities());
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SID)) {
            return false;
        }
        SID other = (SID)obj;
        return Objects.equals(this.getRevision(), other.getRevision()) && Arrays.equals(this.getIdentifierAuthority(), other.getIdentifierAuthority()) && Arrays.equals(this.getSubAuthorities(), other.getSubAuthorities());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("S-");
        b.append(this.revision & 0xFF).append("-");
        if (this.identifierAuthority[0] != 0 || this.identifierAuthority[1] != 0) {
            b.append("0x");
            b.append(Hex.toHexString((byte[])this.identifierAuthority));
        } else {
            long shift = 0L;
            long id = 0L;
            for (int i = this.identifierAuthority.length - 1; i > 1; --i) {
                id += ((long)this.identifierAuthority[i] & 0xFFL) << (int)shift;
                shift += 8L;
            }
            b.append(id);
        }
        for (long part : this.getSubAuthorities()) {
            b.append("-").append(part & 0xFFFFFFFFL);
        }
        return b.toString();
    }

    public static SID fromString(String sidString) throws MalformedSIDStringException {
        String[] split = sidString.toUpperCase().trim().split("-");
        if (split.length < 3) {
            throw new MalformedSIDStringException("Illegal SID format", sidString);
        }
        if (!split[0].equals("S")) {
            throw new MalformedSIDStringException("SID must start with S", sidString);
        }
        try {
            byte[] identifierAuthority;
            byte revision = (byte)Integer.parseInt(split[1]);
            String identifierAuthorityString = split[2];
            if (identifierAuthorityString.toUpperCase().startsWith("0X")) {
                String bytes = identifierAuthorityString.substring(2, identifierAuthorityString.length());
                identifierAuthority = Hex.decode((String)bytes);
            } else {
                long identifierAuthorityValue = Long.parseLong(identifierAuthorityString);
                identifierAuthority = new byte[]{(byte)(identifierAuthorityValue >> 40 & 0xFFL), (byte)(identifierAuthorityValue >> 32 & 0xFFL), (byte)(identifierAuthorityValue >> 24 & 0xFFL), (byte)(identifierAuthorityValue >> 16 & 0xFFL), (byte)(identifierAuthorityValue >> 8 & 0xFFL), (byte)(identifierAuthorityValue & 0xFFL)};
            }
            long[] subAuthorities = new long[split.length - 3];
            for (int i = 0; i < subAuthorities.length; ++i) {
                subAuthorities[i] = Long.parseLong(split[i + 3]);
            }
            return new SID(revision, identifierAuthority, subAuthorities);
        }
        catch (NumberFormatException e) {
            throw new MalformedSIDStringException("Unable to parse SID token: " + e.getMessage(), sidString);
        }
    }

    public static class MalformedSIDStringException
    extends IllegalArgumentException {
        MalformedSIDStringException(String reason, String sidStr) {
            super(String.format("%s: %s", reason, sidStr));
        }
    }
}

