/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc;

import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import java.io.IOException;

public class RPCException
extends IOException {
    private final int returnValue;
    private final SystemErrorCode errorCode;

    public RPCException(String opName, int returnValue) {
        super(RPCException.formatMessage(opName, returnValue));
        this.returnValue = returnValue;
        this.errorCode = SystemErrorCode.getErrorCode(returnValue);
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public SystemErrorCode getErrorCode() {
        return this.errorCode;
    }

    public boolean hasErrorCode() {
        return this.errorCode != null;
    }

    private static String formatMessage(String opName, int returnValue) {
        SystemErrorCode errorCode = SystemErrorCode.getErrorCode(returnValue);
        String errorCodeStr = errorCode == null ? "" : String.format("(%s)", new Object[]{errorCode});
        return String.format("%s returned error code: 0x%08X %s", opName, returnValue, errorCodeStr);
    }
}

