/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc;

public enum Interface {
    WINREG_V1_0("winreg interface", "338cd001-2244-31f1-aaaa-900038001003:v1.0"),
    SRVSVC_V3_0("srvsvc interface", "4b324fc8-1670-01d3-1278-5a47bf6ee188:v3.0"),
    LSASVC_V0_0("lsarpc interface", "12345778-1234-ABCD-EF00-0123456789AB:v0.0"),
    SAMSVC_V1_0("samr interface", "12345778-1234-ABCD-EF00-0123456789AC:v1.0"),
    SVCCTL_V2_0("svcctl_interface", "367abb81-9844-35f1-ad32-98f038001003:v2.0"),
    NDR_32BIT_V2("NDR transfer syntax identifier", "8a885d04-1ceb-11c9-9fe8-08002b104860:v2.0");

    private final String name;
    private final String repr;
    private final byte[] uuid = new byte[16];
    private final short majorVersion;
    private final short minorVersion;

    private Interface(String name, String uuid) {
        this.name = name;
        this.repr = uuid;
        String[] interfaceComponents = uuid.split(":", 2);
        String[] uuidComponents = interfaceComponents[0].split("-", 5);
        String[] uuidBEComponents = new String[]{uuidComponents[0], uuidComponents[1], uuidComponents[2]};
        String[] uuidLEComponents = new String[]{uuidComponents[3], uuidComponents[4]};
        int uuidIndex = 0;
        int uuidIndexNibble = 4;
        for (String uuidComponent : uuidBEComponents) {
            byte[] uuidComponentBytes = uuidComponent.getBytes();
            for (int byteIndex = uuidComponent.length() - 2; byteIndex >= 0; byteIndex -= 2) {
                for (int nibbleIndex = byteIndex; nibbleIndex < byteIndex + 2; ++nibbleIndex) {
                    byte uuidComponentByte = uuidComponentBytes[nibbleIndex];
                    int n2 = uuidIndex++;
                    this.uuid[n2] = (byte)(this.uuid[n2] | (byte)(Character.digit(uuidComponentByte, 16) << uuidIndexNibble));
                    uuidIndexNibble = uuidIndexNibble == 0 ? 4 : 0;
                }
            }
        }
        for (String uuidComponent : uuidLEComponents) {
            for (byte uuidComponentByte : uuidComponent.getBytes()) {
                int n3 = uuidIndex++;
                this.uuid[n3] = (byte)(this.uuid[n3] | (byte)(Character.digit(uuidComponentByte, 16) << uuidIndexNibble));
                uuidIndexNibble = uuidIndexNibble == 0 ? 4 : 0;
            }
        }
        String[] versionComponents = interfaceComponents[1].split("\\.", 2);
        this.majorVersion = Short.valueOf(versionComponents[0].substring(1));
        this.minorVersion = Short.valueOf(versionComponents[1]);
    }

    public String getName() {
        return this.name;
    }

    public String getRepr() {
        return this.repr;
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }
}

