/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc;

import com.hierynomus.protocol.commons.EnumWithValue;
import com.rapid7.client.dcerpc.PDUType;
import com.rapid7.client.dcerpc.PFCFlag;
import com.rapid7.client.dcerpc.io.Hexify;
import com.rapid7.client.dcerpc.io.HexifyImpl;
import com.rapid7.client.dcerpc.io.Packet;
import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import java.io.IOException;
import java.util.Set;

public class Header
extends HexifyImpl
implements Packet,
Hexify {
    private byte majorVersion = (byte)5;
    private byte minorVersion = 0;
    private PDUType pduType;
    private Set<PFCFlag> pfcFlags;
    private byte[] ndr = new byte[]{16, 0, 0, 0};
    private short fragLength = (short)16;
    private short authLength = 0;
    private int callID = 0;

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public PDUType getPDUType() {
        return this.pduType;
    }

    public Set<PFCFlag> getPFCFlags() {
        return this.pfcFlags;
    }

    public byte[] getNDR() {
        return this.ndr;
    }

    public int getFragLength() {
        return this.fragLength;
    }

    public int getAuthLength() {
        return this.authLength;
    }

    public int getCallID() {
        return this.callID;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setPDUType(PDUType pduType) {
        this.pduType = pduType;
    }

    public void setPFCFlags(Set<PFCFlag> pfcFlags) {
        this.pfcFlags = pfcFlags;
    }

    public void setNDR(byte[] ndr) {
        this.ndr = ndr;
    }

    public void setFragLength(short fragLength) {
        this.fragLength = fragLength;
    }

    public void setAuthLength(short authLength) {
        this.authLength = authLength;
    }

    public void setCallID(int callID) {
        this.callID = callID;
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        if (null == this.getPDUType()) {
            throw new IllegalStateException("Invalid PDU type: " + (Object)((Object)this.getPDUType()));
        }
        if (null == this.getPFCFlags()) {
            throw new IllegalStateException("Invalid PFC flag(s): " + this.getPFCFlags());
        }
        packetOut.writeByte(this.getMajorVersion());
        packetOut.writeByte(this.getMinorVersion());
        packetOut.writeByte((byte)this.getPDUType().getValue());
        packetOut.writeByte((byte)EnumWithValue.EnumUtils.toLong(this.getPFCFlags()));
        packetOut.write(this.getNDR());
        packetOut.writeShort(this.getFragLength());
        packetOut.writeShort(0);
        packetOut.writeInt(this.getCallID());
    }

    @Override
    public void unmarshal(PacketInput packetIn) throws IOException {
        this.setMajorVersion(packetIn.readByte());
        this.setMinorVersion(packetIn.readByte());
        if (5 != this.getMajorVersion() || 0 != this.getMinorVersion()) {
            throw new IOException(String.format("Version mismatch: %d.%d != 5.0", this.getMajorVersion(), this.getMinorVersion()));
        }
        byte pduTypePrimitive = packetIn.readByte();
        PDUType pduType = (PDUType)EnumWithValue.EnumUtils.valueOf((long)pduTypePrimitive, PDUType.class, null);
        if (pduType == null) {
            throw new IOException(String.format("PDU type invalid: %d", new Object[]{pduType}));
        }
        this.setPDUType(pduType);
        this.setPFCFlags(EnumWithValue.EnumUtils.toEnumSet((long)packetIn.readByte(), PFCFlag.class));
        byte[] ndr = new byte[4];
        packetIn.readFully(ndr);
        if (ndr[0] != 16) {
            throw new IOException(String.format("Integer and Character representation mismatch: %d", ndr[0]));
        }
        if (ndr[1] != 0) {
            throw new IOException(String.format("Floating-Point representation mismatch: %d", ndr[1]));
        }
        this.setNDR(ndr);
        this.setFragLength(packetIn.readShort());
        this.setAuthLength(packetIn.readShort());
        this.setCallID(packetIn.readInt());
    }
}

