/*
 * Decompiled with CFR 0.152.
 */
package com.rany.albeg.wein.bottomleftmenu;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.rany.albeg.wein.bottomleftmenu.R;

public class BottomLeftMenuItem
extends LinearLayout {
    private TextView mText;
    private ImageView mImage;
    private int mIdentifier;
    private Context mContext;

    public BottomLeftMenuItem(Context context, int iconResource, int textResource, int identifier) {
        super(context);
        this.mContext = context;
        this.mIdentifier = identifier;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.initChildViews(iconResource, textResource);
        this.addViews();
    }

    private void addViews() {
        this.addView((View)this.mImage);
        this.addView((View)this.mText);
    }

    public int getIdentifier() {
        return this.mIdentifier;
    }

    private void initChildViews(int iconResource, int textResouce) {
        this.mImage = new ImageView(this.mContext);
        this.mText = new TextView(this.mContext);
        LinearLayout.LayoutParams imageLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        imageLayoutParams.gravity = 17;
        Resources res = this.getResources();
        int defIconPadding = (int)res.getDimension(R.dimen.padding_default_item_icon);
        int defTextRightMargin = (int)res.getDimension(R.dimen.margin_default_text_right);
        int defTextPadding = (int)res.getDimension(R.dimen.padding_default_text);
        this.mImage.setImageResource(iconResource);
        this.mImage.setPadding(defIconPadding, defIconPadding, defIconPadding, defIconPadding);
        this.mImage.setLayoutParams((ViewGroup.LayoutParams)imageLayoutParams);
        LinearLayout.LayoutParams textLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        textLayoutParams.gravity = 17;
        textLayoutParams.setMargins(0, 0, defTextRightMargin, 0);
        this.mText.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
        this.mText.setPadding(defTextPadding, defTextPadding, defTextPadding, defTextPadding);
        this.mText.setText(textResouce);
    }

    public TextView getTextView() {
        return this.mText;
    }

    public ImageView getImageView() {
        return this.mImage;
    }

    public static interface OnBottomLeftMenuItemClickListener {
        public void onClick(BottomLeftMenuItem var1);
    }
}

