/*
 * Decompiled with CFR 0.152.
 */
package com.rany.albeg.wein.bottomleftmenu;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.rany.albeg.wein.bottomleftmenu.BottomLeftMenuItem;
import com.rany.albeg.wein.bottomleftmenu.OpenCloseMenuAnimation;
import com.rany.albeg.wein.bottomleftmenu.OpenCloseMenuAnimationFactory;
import com.rany.albeg.wein.bottomleftmenu.R;

public class BottomLeftMenu
extends ScrollView
implements View.OnClickListener {
    private boolean mIsOpened;
    private OpenCloseMenuAnimation mOpenCloseAnimation;
    private LinearLayout mViewsContainer;
    private BottomLeftMenuItem.OnBottomLeftMenuItemClickListener mOnBottomLeftMenuItemClickListener;
    private int mTextColorRes;
    private float mTextSize;
    private int mNormalStateColor;
    private int mPressedStateColor;
    private boolean mShowDivider;
    private int mDividerHeight;
    private int mDividerColor;
    private OPEN_CLOSE_ANIMATION mOpenCloseAnimationType;
    private Context mContext;

    public BottomLeftMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BottomLeftMenu);
        this.initAttrs(ta);
        this.init(context);
    }

    public BottomLeftMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BottomLeftMenu, defStyle, 0);
        this.initAttrs(ta);
        this.init(context);
    }

    private void initAttrs(TypedArray a) {
        Resources r = this.getResources();
        this.mTextColorRes = a.getColor(R.styleable.BottomLeftMenu_itemTextColor, -16777216);
        this.mTextSize = a.getDimension(R.styleable.BottomLeftMenu_itemTextSize, r.getDimension(R.dimen.default_item_text_size));
        this.mPressedStateColor = a.getColor(R.styleable.BottomLeftMenu_itemPressedStateColor, r.getColor(R.color.default_item_pressed_state_color));
        this.mNormalStateColor = a.getColor(R.styleable.BottomLeftMenu_itemNormalStateColor, r.getColor(17170445));
        this.mShowDivider = a.getBoolean(R.styleable.BottomLeftMenu_showDivider, true);
        this.mDividerHeight = (int)a.getDimension(R.styleable.BottomLeftMenu_dividerHeight, r.getDimension(R.dimen.default_divider_height));
        this.mDividerColor = a.getColor(R.styleable.BottomLeftMenu_dividerColor, r.getColor(R.color.default_divider_color));
        this.mOpenCloseAnimationType = OPEN_CLOSE_ANIMATION.values()[a.getInt(R.styleable.BottomLeftMenu_openingDirection, 0)];
        a.recycle();
    }

    private void init(Context context) {
        this.mContext = context;
        this.mViewsContainer = new LinearLayout(context);
        this.mViewsContainer.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mViewsContainer.setOrientation(1);
        this.setBackgroundResource(R.drawable.menu_bg);
        this.setVisibility(8);
        this.mIsOpened = false;
        this.setOpenCloseAnimation(OpenCloseMenuAnimationFactory.getAnimation(context, this.mOpenCloseAnimationType));
        if (this.mShowDivider) {
            this.setDivider();
        }
        this.addView((View)this.mViewsContainer);
    }

    public void setOpenCloseAnimation(OpenCloseMenuAnimation openCloseAnimation) {
        this.mOpenCloseAnimation = openCloseAnimation;
    }

    private void setDivider() {
        ShapeDrawable divider = new ShapeDrawable();
        divider.setIntrinsicHeight(this.mDividerHeight);
        divider.getPaint().setColor(this.mDividerColor);
        this.mViewsContainer.setDividerDrawable((Drawable)divider);
        this.mViewsContainer.setShowDividers(2);
    }

    public void setOnBottomLeftMenuItemClickListener(BottomLeftMenuItem.OnBottomLeftMenuItemClickListener l) {
        this.mOnBottomLeftMenuItemClickListener = l;
    }

    private void addMenuItem(BottomLeftMenuItem item) {
        this.setSelector(item);
        item.getTextView().setTextColor(this.mTextColorRes);
        item.getTextView().setTextSize(this.mTextSize);
        item.setOnClickListener(this);
        this.mViewsContainer.addView((View)item);
    }

    public void addMenuItem(int iconResource, int textResource, int identifier) {
        this.addMenuItem(new BottomLeftMenuItem(this.mContext, iconResource, textResource, identifier));
    }

    @SuppressLint(value={"NewApi"})
    private void setSelector(BottomLeftMenuItem item) {
        ColorDrawable normalDrawable = new ColorDrawable(this.mNormalStateColor);
        ColorDrawable pressedDrawable = new ColorDrawable(this.mPressedStateColor);
        StateListDrawable selector = new StateListDrawable();
        selector.addState(new int[]{16842919}, (Drawable)pressedDrawable);
        selector.addState(new int[0], (Drawable)normalDrawable);
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            item.setBackgroundDrawable((Drawable)selector);
        } else {
            item.setBackground((Drawable)selector);
        }
    }

    public boolean isOpened() {
        return this.mIsOpened;
    }

    public void openMenu() {
        if (!this.mIsOpened) {
            this.setVisibility(0);
            this.startAnimation(this.mOpenCloseAnimation.open());
            this.mIsOpened = true;
        }
    }

    public void closeMenu() {
        if (this.mIsOpened) {
            this.setVisibility(8);
            this.startAnimation(this.mOpenCloseAnimation.close());
            this.mIsOpened = false;
        }
    }

    public BottomLeftMenuItem getMenuItemAt(int index) {
        return (BottomLeftMenuItem)this.mViewsContainer.getChildAt(index);
    }

    public void onClick(View v) {
        final BottomLeftMenuItem item = (BottomLeftMenuItem)v;
        this.setVisibility(8);
        Animation closeAnim = this.mOpenCloseAnimation.close();
        closeAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (BottomLeftMenu.this.mOnBottomLeftMenuItemClickListener != null) {
                    BottomLeftMenu.this.mOnBottomLeftMenuItemClickListener.onClick(item);
                }
                BottomLeftMenu.this.mIsOpened = false;
            }
        });
        this.startAnimation(closeAnim);
    }

    public static enum OPEN_CLOSE_ANIMATION {
        BOTTOM_TOP,
        LEFT_RIGHT,
        FADE_IN_OUT;

    }
}

