/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets.stepview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import java.util.HashMap;
import java.util.Map;
import org.tcshare.androidutils.R;
import org.tcshare.utils.DensityUtil;

public class FlowViewHorizontal
extends View {
    private Paint bgPaint;
    private Paint proPaint;
    private float bgRadius;
    private float proRadius;
    private float startX;
    private float stopX;
    private float bgCenterY;
    private int lineBgWidth;
    private int bgColor;
    private int lineProWidth;
    private int proColor;
    private int textPadding;
    private int timePadding;
    private int maxStep;
    private int textSize;
    private int proStep;
    private int interval;
    private String[] titles = new String[]{"\u63d0\u4ea4", "\u63a5\u5355", "\u53d6\u4ef6", "\u914d\u9001", "\u5b8c\u6210"};
    private String[] times = new String[]{"12:20"};
    private final Map<Integer, String> mapPos = new HashMap<Integer, String>();

    public FlowViewHorizontal(Context context) {
        this(context, null);
    }

    public FlowViewHorizontal(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlowViewHorizontal(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FlowViewHorizontal);
        this.bgRadius = ta.getDimension(R.styleable.FlowViewHorizontal_h_bg_radius, 10.0f);
        this.proRadius = ta.getDimension(R.styleable.FlowViewHorizontal_h_pro_radius, 8.0f);
        this.lineBgWidth = (int)ta.getDimension(R.styleable.FlowViewHorizontal_h_bg_width, 3.0f);
        this.bgColor = ta.getColor(R.styleable.FlowViewHorizontal_h_bg_color, Color.parseColor((String)"#cdcbcc"));
        this.lineProWidth = (int)ta.getDimension(R.styleable.FlowViewHorizontal_h_pro_width, 2.0f);
        this.proColor = ta.getColor(R.styleable.FlowViewHorizontal_h_pro_color, Color.parseColor((String)"#029dd5"));
        this.textPadding = (int)ta.getDimension(R.styleable.FlowViewHorizontal_h_text_padding, 20.0f);
        this.timePadding = (int)ta.getDimension(R.styleable.FlowViewHorizontal_h_time_padding, 30.0f);
        this.maxStep = ta.getInt(R.styleable.FlowViewHorizontal_h_max_step, 5);
        this.textSize = (int)ta.getDimension(R.styleable.FlowViewHorizontal_h_textsize, 20.0f);
        this.proStep = ta.getInt(R.styleable.FlowViewHorizontal_h_pro_step, 1);
        ta.recycle();
        this.init();
    }

    private void init() {
        this.bgPaint = new Paint();
        this.bgPaint.setAntiAlias(true);
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.bgPaint.setColor(this.bgColor);
        this.bgPaint.setStrokeWidth((float)this.lineBgWidth);
        this.bgPaint.setTextSize((float)this.textSize);
        this.bgPaint.setTextAlign(Paint.Align.CENTER);
        this.proPaint = new Paint();
        this.proPaint.setAntiAlias(true);
        this.proPaint.setStyle(Paint.Style.FILL);
        this.proPaint.setColor(this.proColor);
        this.proPaint.setStrokeWidth((float)this.lineProWidth);
        this.proPaint.setTextSize((float)this.textSize);
        this.proPaint.setTextAlign(Paint.Align.CENTER);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int bgWidth = widthMode == 0x40000000 ? View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight() : DensityUtil.dp2px(this.getContext(), 311);
        int bgHeight = heightMode == 0x40000000 ? View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom() : DensityUtil.dp2px(this.getContext(), 49);
        float left = (float)this.getPaddingLeft() + this.bgRadius;
        this.stopX = (float)bgWidth - this.bgRadius;
        this.startX = left;
        this.bgCenterY = bgHeight / 2;
    }

    protected void onDraw(Canvas canvas) {
        this.interval = (int)((this.stopX - this.startX) / (float)(this.maxStep - 1));
        this.drawBg(canvas);
        this.drawProgress(canvas);
        this.drawText(canvas);
    }

    private void drawText(Canvas canvas) {
        for (int i = 0; i < this.maxStep; ++i) {
            String title;
            if (i < this.proStep) {
                this.setPaintColor(i);
                if (null != this.titles && i < this.titles.length) {
                    canvas.drawText(this.titles[i], this.startX + (float)(i * this.interval), this.bgCenterY - (float)this.textPadding, this.proPaint);
                }
                if (null == this.times || i >= this.times.length) continue;
                canvas.drawText(this.times[i], this.startX + (float)(i * this.interval), this.bgCenterY + (float)this.timePadding, this.proPaint);
                continue;
            }
            if (null == this.titles || i >= this.titles.length || null == (title = this.titles[i])) continue;
            canvas.drawText(title, this.startX + (float)(i * this.interval), this.bgCenterY - (float)this.textPadding, this.bgPaint);
        }
    }

    private void setPaintColor(int index) {
        if (this.mapPos.get(index) != null) {
            this.proPaint.setColor(Color.parseColor((String)this.mapPos.get(index)));
        } else {
            this.proPaint.setColor(this.proColor);
        }
    }

    private void drawProgress(Canvas canvas) {
        float lastLeft = this.startX;
        for (int i = 0; i < this.proStep; ++i) {
            this.setPaintColor(i);
            int linePro = i == 0 || i == this.maxStep - 1 ? this.interval / 2 : this.interval;
            canvas.drawLine(lastLeft, this.bgCenterY, lastLeft + (float)linePro, this.bgCenterY, this.proPaint);
            lastLeft += (float)linePro;
            canvas.drawCircle(this.startX + (float)(i * this.interval), this.bgCenterY, this.proRadius, this.proPaint);
        }
    }

    private void drawBg(Canvas canvas) {
        canvas.drawLine(this.startX, this.bgCenterY, this.stopX, this.bgCenterY, this.bgPaint);
        for (int i = 0; i < this.maxStep; ++i) {
            canvas.drawCircle(this.startX + (float)(i * this.interval), this.bgCenterY, this.bgRadius, this.bgPaint);
        }
    }

    public void setProgress(int progress, int maxStep, String[] titles, String[] times) {
        this.proStep = progress;
        this.maxStep = maxStep;
        this.titles = titles;
        this.times = times;
        this.invalidate();
    }

    public void setKeyColorByName(Map<String, String> map, boolean reset) {
        for (int i = 0; i < this.titles.length; ++i) {
            if (reset) {
                this.mapPos.put(i, map.get(this.titles[i]));
                continue;
            }
            if (map.get(this.titles[i]) == null) continue;
            this.mapPos.put(i, map.get(this.titles[i]));
        }
    }

    public void setKeyColorByIndex(Map<Integer, String> map) {
        this.mapPos.putAll(map);
    }
}

