/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import org.tcshare.widgets.SwipeMenuLayout;

public class SwipeMenuRecyclerView
extends RecyclerView {
    public static final int TOUCH_STATE_NONE = 0;
    public static final int TOUCH_STATE_X = 1;
    public static final int TOUCH_STATE_Y = 2;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_RIGHT = -1;
    protected int mDirection = 1;
    protected float mDownX;
    protected float mDownY;
    protected int mTouchState;
    protected int mTouchPosition;
    protected SwipeMenuLayout mTouchView;
    protected OnSwipeListener mOnSwipeListener;
    protected Interpolator mCloseInterpolator;
    protected Interpolator mOpenInterpolator;
    protected RecyclerView.LayoutManager mLlm;
    protected ViewConfiguration mViewConfiguration;
    protected long startClickTime;
    protected float dx;
    protected float dy;
    private boolean actionMode;

    public SwipeMenuRecyclerView(Context context) {
        this(context, null);
    }

    public SwipeMenuRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeMenuRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.mTouchState = 0;
        this.mViewConfiguration = ViewConfiguration.get((Context)this.getContext());
    }

    public void setCloseInterpolator(Interpolator interpolator) {
        this.mCloseInterpolator = interpolator;
    }

    public void setOpenInterpolator(Interpolator interpolator) {
        this.mOpenInterpolator = interpolator;
    }

    public Interpolator getOpenInterpolator() {
        return this.mOpenInterpolator;
    }

    public Interpolator getCloseInterpolator() {
        return this.mCloseInterpolator;
    }

    public void setActionMode(boolean actionMode) {
        this.actionMode = actionMode;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() != 0 && this.mTouchView == null) {
            return super.onInterceptTouchEvent(ev);
        }
        if (this.actionMode) {
            return super.onInterceptTouchEvent(ev);
        }
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.dx = 0.0f;
                this.dy = 0.0f;
                this.startClickTime = System.currentTimeMillis();
                int oldPos = this.mTouchPosition;
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                this.mTouchState = 0;
                this.mTouchPosition = this.getChildAdapterPosition(this.findChildViewUnder((int)ev.getX(), (int)ev.getY()));
                if (this.mTouchPosition == oldPos && this.mTouchView != null && this.mTouchView.isOpen()) {
                    this.mTouchState = 1;
                    this.mTouchView.onSwipe(ev);
                }
                View view = null;
                RecyclerView.ViewHolder vh = this.findViewHolderForAdapterPosition(this.mTouchPosition);
                if (vh != null) {
                    view = vh.itemView;
                }
                if (this.mTouchPosition != oldPos && this.mTouchView != null && this.mTouchView.isOpen()) {
                    this.mTouchView.smoothCloseMenu();
                    this.mTouchView = null;
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)ev);
                    cancelEvent.setAction(3);
                    super.onTouchEvent(cancelEvent);
                    return true;
                }
                if (view instanceof SwipeMenuLayout) {
                    this.mTouchView = (SwipeMenuLayout)view;
                    this.mTouchView.setSwipeDirection(this.mDirection);
                }
                if (this.mTouchView == null) break;
                this.mTouchView.onSwipe(ev);
                break;
            }
            case 2: {
                this.dy = Math.abs(ev.getY() - this.mDownY);
                this.dx = Math.abs(ev.getX() - this.mDownX);
                if (this.mTouchState == 1 && this.mTouchView.isSwipeEnable()) {
                    this.mTouchView.onSwipe(ev);
                    ev.setAction(3);
                    super.onTouchEvent(ev);
                    break;
                }
                if (this.mTouchState != 0 || !this.mTouchView.isSwipeEnable()) break;
                if (Math.abs(this.dy) > (float)this.mViewConfiguration.getScaledTouchSlop()) {
                    this.mTouchState = 2;
                    break;
                }
                if (!(this.dx > (float)this.mViewConfiguration.getScaledTouchSlop())) break;
                this.mTouchState = 1;
                if (this.mOnSwipeListener == null) break;
                this.mOnSwipeListener.onSwipeStart(this.mTouchPosition);
                break;
            }
            case 1: {
                float eY;
                boolean isOutY;
                long clickDuration;
                boolean isCloseOnUpEvent = false;
                if (this.mTouchState == 1 && this.mTouchView.isSwipeEnable()) {
                    boolean bl = isCloseOnUpEvent = !this.mTouchView.onSwipe(ev);
                    if (this.mOnSwipeListener != null) {
                        this.mOnSwipeListener.onSwipeEnd(this.mTouchPosition);
                    }
                    if (!this.mTouchView.isOpen()) {
                        this.mTouchPosition = -1;
                        this.mTouchView = null;
                    }
                    ev.setAction(3);
                    super.onTouchEvent(ev);
                }
                boolean isOutDuration = (clickDuration = System.currentTimeMillis() - this.startClickTime) > (long)ViewConfiguration.getLongPressTimeout();
                boolean isOutX = this.dx > (float)this.mViewConfiguration.getScaledTouchSlop();
                boolean bl = isOutY = this.dy > (float)this.mViewConfiguration.getScaledTouchSlop();
                if (isOutDuration || isOutX || isOutY) {
                    return true;
                }
                float eX = ev.getX();
                View upView = this.findChildViewUnder(eX, eY = ev.getY());
                if (!(upView instanceof SwipeMenuLayout)) break;
                SwipeMenuLayout smView = (SwipeMenuLayout)upView;
                int x = (int)eX - smView.getLeft();
                int y = (int)eY - smView.getTop();
                View menuView = smView.getMenuView();
                float translationX = ViewCompat.getTranslationX((View)menuView);
                float translationY = ViewCompat.getTranslationY((View)menuView);
                if ((float)x >= (float)menuView.getLeft() + translationX && (float)x <= (float)menuView.getRight() + translationX && (float)y >= (float)menuView.getTop() + translationY && (float)y <= (float)menuView.getBottom() + translationY || !isCloseOnUpEvent) break;
                return true;
            }
            case 3: {
                if (this.mTouchView == null || !this.mTouchView.isSwipeEnable()) break;
                ev.setAction(1);
                this.mTouchView.onSwipe(ev);
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void smoothOpenMenu(int position) {
        View view = this.mLlm.findViewByPosition(position);
        if (view instanceof SwipeMenuLayout) {
            this.mTouchPosition = position;
            if (this.mTouchView != null && this.mTouchView.isOpen()) {
                this.mTouchView.smoothCloseMenu();
            }
            this.mTouchView = (SwipeMenuLayout)view;
            this.mTouchView.setSwipeDirection(this.mDirection);
            this.mTouchView.smoothOpenMenu();
        }
    }

    public void smoothCloseMenu() {
        if (this.mTouchView != null && this.mTouchView.isOpen()) {
            this.mTouchView.smoothCloseMenu();
        }
    }

    public void setOnSwipeListener(OnSwipeListener onSwipeListener) {
        this.mOnSwipeListener = onSwipeListener;
    }

    public SwipeMenuLayout getTouchView() {
        return this.mTouchView;
    }

    public void setSwipeDirection(int direction) {
        this.mDirection = direction;
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        this.mLlm = layout2;
    }

    public static interface OnSwipeListener {
        public void onSwipeStart(int var1);

        public void onSwipeEnd(int var1);
    }
}

