/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.tcshare.androidutils.R;

public class RadarView
extends View {
    private Bitmap pointImg;
    private final boolean usePointBitmap = true;
    private final float pointRadius = 10.0f;
    private final int MAX_POINT_SHOW = 100;
    private final MaskFilter outLightFilter = new BlurMaskFilter(10.0f, BlurMaskFilter.Blur.SOLID);
    private final int showPointAngel = 300;
    private final int bgColor = -4662020;
    private final int bgRadar = -13469516;
    private final int colorCircle = -13514254;
    private final int radarColor = Color.parseColor((String)"#AA0000FF");
    private final int mNumCicle = 4;
    private final int mNumLines = 4;
    private SweepGradient sweepGradient = null;
    private boolean isSearching = false;
    private final Paint mPaint = new Paint();
    private int mCurrentAngel = 0;
    private final List<MyPoint> mPointArray = new ArrayList<MyPoint>();
    private int mWidth = 0;
    private int mHeight = 0;
    private int mOutWidth = 0;
    private int mCx = 0;
    private int mCy = 0;
    private int mOutsideRadius = 0;
    private int mInsideRadius = 0;

    public RadarView(Context context) {
        super(context);
        this.init(context);
    }

    public RadarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public RadarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public RadarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        this.pointImg = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.point);
        this.setLayerType(2, null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mWidth == 0 || this.mHeight == 0) {
            int minimumWidth = this.getSuggestedMinimumWidth();
            int minimumHeight = this.getSuggestedMinimumHeight();
            this.mWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
            this.mHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
            this.mCx = this.mWidth / 2;
            this.mCy = this.mHeight / 2;
            this.mOutWidth = this.mWidth / 10;
            this.mOutsideRadius = this.mWidth / 2;
            this.mInsideRadius = (this.mWidth - this.mOutWidth) / 4 / 2;
            this.sweepGradient = new SweepGradient((float)this.mCx, (float)this.mCy, 0, this.radarColor);
        }
    }

    protected void onDraw(@NonNull Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-4662020);
        this.mPaint.setShader(null);
        this.mPaint.setAlpha(255);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.mOutsideRadius, this.mPaint);
        this.mPaint.setColor(-13469516);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.mInsideRadius * 4.0f, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-13514254);
        for (int num = 4; num >= 1; --num) {
            canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.mInsideRadius * (float)num, this.mPaint);
        }
        double angle = 45.0;
        int lineRadius = this.mInsideRadius * 4;
        for (int num = 0; num < 4; ++num) {
            double radianS = Math.toRadians((double)num * angle);
            double radianE = Math.toRadians((double)num * angle + 180.0);
            canvas.drawLine((float)((double)this.mCx + (double)lineRadius * Math.cos(radianS)), (float)((double)this.mCy + (double)lineRadius * Math.sin(radianS)), (float)((double)this.mCx + (double)lineRadius * Math.cos(radianE)), (float)((double)this.mCy + (double)lineRadius * Math.sin(radianE)), this.mPaint);
        }
        if (this.isSearching) {
            canvas.save();
            canvas.rotate((float)this.mCurrentAngel, (float)this.mCx, (float)this.mCy);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setShader((Shader)this.sweepGradient);
            this.mCurrentAngel += 3;
            canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)(this.mInsideRadius * 4), this.mPaint);
            canvas.restore();
            this.mPaint.setColor(-1);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setShader(null);
            for (int i = this.mPointArray.size() - 1; i >= 0; --i) {
                MyPoint p = this.mPointArray.get(i);
                if (this.mCurrentAngel >= 300 && this.mCurrentAngel - 300 > p.angel) {
                    this.mPointArray.remove(i);
                    continue;
                }
                int sAngel = (this.mCurrentAngel - p.angel - 1) % 300;
                if (sAngel == 0) {
                    this.mPaint.setAlpha(255);
                } else {
                    this.mPaint.setAlpha((int)(255.0f - (float)sAngel / 300.0f * 255.0f));
                }
                canvas.drawBitmap(this.pointImg, p.pos.x - (float)this.pointImg.getWidth() / 2.0f, p.pos.y - (float)this.pointImg.getHeight() / 2.0f, this.mPaint);
            }
            this.invalidate();
        }
    }

    public final void setSearching(boolean status) {
        this.isSearching = status;
        if (!this.isSearching) {
            this.mPointArray.clear();
        }
        this.invalidate();
    }

    public final boolean isSearching() {
        return this.isSearching;
    }

    public final void addPoint(float percent) {
        if (!this.isSearching) {
            return;
        }
        double radian = Math.toRadians(this.mCurrentAngel);
        float lineRadius = (float)(this.mInsideRadius * 4) * percent;
        float pX = (float)((double)this.mCx + (double)lineRadius * Math.cos(radian));
        float pY = (float)((double)this.mCy + (double)lineRadius * Math.sin(radian));
        MyPoint point = new MyPoint(percent, new PointF(pX, pY), this.mCurrentAngel);
        this.mPointArray.add(point);
        if (this.mPointArray.size() > 100) {
            this.mPointArray.remove(0);
        }
        this.invalidate();
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result;
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (View.MeasureSpec.getMode((int)measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.max(specSize, desired);
                break;
            }
            case 0x40000000: {
                result = specSize;
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    public static final class MyPoint {
        float percent;
        PointF pos;
        int angel;

        public String toString() {
            return "MyPoint(percent=" + this.percent + ", pos=" + this.pos + "\uff0c mOffsetArgs=" + this.angel + ",)";
        }

        public MyPoint(float percent, @NonNull PointF pos, int angel) {
            this.percent = percent;
            this.pos = pos;
            this.angel = angel;
        }
    }
}

