/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;

public class PalletteView
implements AdapterView.OnItemClickListener {
    private final Context ctx;
    private ColorPickFinish listener;
    private GridView gridView;
    private int bgColor = -1;
    private String[] colors = new String[]{"#000000", "#7F7F7F", "#880015", "#ED1C24", "#FF7F27", "#FFFFFF", "#C3C3C3", "#B97A57", "#FFAEC9", "#FFC90E", "#FFF200", "#22B14C", "#00A2E8", "#3F48CC", "#A349A4", "#EFE4B0", "#B5E61D", "#99D9EA", "#7092BE", "#C8BFE7"};
    private static final int numColumns = 5;
    private static final int imgWidth = 36;
    private static final int imgHeight = 36;
    private static final int horizontalSpacing = 8;
    private static final int verticalSpacing = 8;
    private static final float padding = 5.0f;
    private PopupWindow pw;
    private ColorAdapter adapter;

    public PalletteView(Context context) {
        this.ctx = context;
    }

    public PalletteView(Context context, ColorPickFinish listener) {
        this.ctx = context;
        this.listener = listener;
    }

    public void setListener(ColorPickFinish listener) {
        this.listener = listener;
    }

    public void togglePallete(View anchor) {
        if (this.pw == null) {
            View v = this.getContentView(this.ctx);
            int width = (int)PalletteView.dip2px(this.ctx, 212.0f);
            int height = (int)PalletteView.dip2px(this.ctx, (float)this.colors.length / 5.0f * 44.0f);
            this.pw = new PopupWindow(v, width, height, true);
            this.pw.setBackgroundDrawable((Drawable)new BitmapDrawable());
            this.pw.setOutsideTouchable(true);
        }
        if (this.pw.isShowing()) {
            this.pw.dismiss();
        } else {
            this.pw.showAsDropDown(anchor);
        }
    }

    private View getContentView(Context ctx) {
        if (this.gridView == null) {
            int pd = (int)PalletteView.dip2px(ctx, 5.0f);
            this.gridView = new GridView(ctx);
            this.adapter = new ColorAdapter(this.colors, ctx);
            this.gridView.setBackgroundColor(this.bgColor);
            this.gridView.setPadding(pd, pd, pd, pd);
            this.gridView.setAdapter((ListAdapter)this.adapter);
            this.gridView.setNumColumns(5);
            this.gridView.setHorizontalSpacing((int)PalletteView.dip2px(ctx, 8.0f));
            this.gridView.setVerticalSpacing(8);
            this.gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        }
        return this.gridView;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.listener != null) {
            this.listener.onSelected(this.adapter.getItem(position));
        }
        this.pw.dismiss();
    }

    public static float dip2px(Context ctx, float dip) {
        float scale = ctx.getResources().getDisplayMetrics().density;
        return dip * scale;
    }

    public static float px2dip(Context ctx, float px) {
        float scale = ctx.getResources().getDisplayMetrics().density;
        return px / scale;
    }

    public static interface ColorPickFinish {
        public void onSelected(int var1);
    }

    private class ColorAdapter
    extends BaseAdapter {
        private final String[] colors;
        private final Context ctx;

        public ColorAdapter(String[] colors, Context ctx) {
            this.colors = colors != null ? colors : new String[0];
            this.ctx = ctx;
        }

        public int getCount() {
            return this.colors.length;
        }

        public Integer getItem(int position) {
            return Color.parseColor((String)this.colors[position]);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = new ImageView(this.ctx);
                int width = (int)PalletteView.dip2px(this.ctx, 36.0f);
                int height = (int)PalletteView.dip2px(this.ctx, 36.0f);
                AbsListView.LayoutParams lp = new AbsListView.LayoutParams(width, height);
                convertView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
            try {
                convertView.setBackgroundColor(this.getItem(position).intValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return convertView;
        }
    }
}

