/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class MaxHeightGridLayoutManager
extends GridLayoutManager {
    private static final int CHILD_WIDTH = 0;
    private static final int CHILD_HEIGHT = 1;
    private static final int DEFAULT_CHILD_SIZE = 100;
    private final int[] childDimensions = new int[2];
    private int childSize = 100;
    private boolean hasChildSize;
    private int[] mMeasuredDimension = new int[2];

    public MaxHeightGridLayoutManager(Context context, int spanCount) {
        super(context, spanCount);
    }

    public MaxHeightGridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout) {
        super(context, spanCount, orientation, reverseLayout);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            try {
                this.measureScrapChild(recycler, i, widthSpec, View.MeasureSpec.makeMeasureSpec((int)i, (int)0), this.mMeasuredDimension);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            if (this.getOrientation() == 0) {
                width += this.mMeasuredDimension[0];
                if (i != 0) continue;
                height = this.mMeasuredDimension[1];
                continue;
            }
            height += this.mMeasuredDimension[1];
            if (i != 0) continue;
            width = this.mMeasuredDimension[0];
        }
        switch (widthMode) {
            default: 
        }
        switch (heightMode) {
            case 0x40000000: {
                height = heightSize;
            }
        }
        this.setMeasuredDimension(widthSpec, height);
    }

    private void measureScrapChild(RecyclerView.Recycler recycler, int position, int widthSpec, int heightSpec, int[] measuredDimension) {
        View view = recycler.getViewForPosition(position);
        if (view != null) {
            RecyclerView.LayoutParams p = (RecyclerView.LayoutParams)view.getLayoutParams();
            int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)p.height);
            view.measure(widthSpec, childHeightSpec);
            measuredDimension[0] = view.getMeasuredWidth() + p.leftMargin + p.rightMargin;
            measuredDimension[1] = view.getMeasuredHeight() + p.bottomMargin + p.topMargin;
            recycler.recycleView(view);
        }
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        super.onLayoutChildren(recycler, state);
    }
}

