/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.Nullable;
import java.text.DecimalFormat;

public class GaugeView
extends View {
    protected int bgRound1 = Color.parseColor((String)"#99122a73");
    protected int bgRound2 = Color.parseColor((String)"#66122a73");
    protected int bgRound3 = Color.parseColor((String)"#22142f80");
    protected int bgRound4 = Color.parseColor((String)"#0e2267");
    protected int circle1 = Color.parseColor((String)"#0d1d4c");
    protected int bgRadius1;
    protected int bgRadius2;
    protected int bgRadius3;
    protected int bgRadius4;
    protected int circleRadius1;
    protected int circleRadius2;
    protected Paint roundPaint;
    protected int mWidth;
    protected int mHeight;
    protected int mCx;
    protected int mCy;
    protected int radius;
    protected Paint pointerPaint;
    protected float textSizeDial = 14.0f;
    protected Paint.FontMetrics pointerFontMetrics;
    protected Paint labelPaint;
    protected int radiusDial;
    protected float maxVal = 150.0f;
    protected float minVal = -50.0f;
    protected int lowDialLimit = 20;
    protected int highDialLimit = 80;
    protected int colorDialLower = Color.parseColor((String)"#00faff");
    protected int colorDialMiddle = -16711936;
    protected int colorDialHigh = -65536;
    protected int lengthLDial = 16;
    protected int lengthSDial = 8;
    protected float strokeLDial = 3.0f;
    protected float strokeSDial = 1.0f;
    protected float circleRadius1StrokeWidth = 2.0f;
    protected float circleRadius2StrokeWidth = 4.0f;
    protected float pointerLineDegree;
    protected float arcStartDegree = this.pointerLineDegree = 135.0f;
    protected Paint valPaint;
    protected Paint.FontMetrics labelFontMetrics;
    protected Paint.FontMetrics valFontMetrics;
    protected String valText = "";
    protected float realVal;
    protected float valTextSize = 40.0f;
    protected int valTextColor = -1;
    protected String labelText = "";
    protected float labelTextSize = 20.0f;
    protected int labelTextColor = -1;
    protected Paint arcPaint;
    protected RectF mArcRect = new RectF();
    protected RectF mCircleArcRect1 = new RectF();
    protected RectF mCircleArcRect2 = new RectF();
    protected float arcPaintStrokeWidth = 2.0f;
    protected int arcColor = Color.parseColor((String)"#ff8e00");
    protected int[] colors = new int[]{0, 0, 0, this.arcColor};
    protected int[] colorsArcLine = new int[]{this.arcColor, this.arcColor, 0};
    protected Shader arcShader;
    protected Shader arcLineShader;
    protected float sweepAngle = 0.0f;
    protected String formatter = "%.0f";
    protected int drawDialNum = 100;
    protected int dialStep = 10;
    protected float valRange;
    protected float stepDegree;
    protected float sRoateDegree;
    protected DecimalFormat decimalFormat = new DecimalFormat(".0");
    private Bitmap pLineCache;

    public GaugeView(Context context) {
        super(context);
        this.init();
    }

    public GaugeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GaugeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public GaugeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    protected void init() {
        this.roundPaint = new Paint(1);
        this.arcPaint = new Paint();
        this.arcPaint.setAntiAlias(true);
        this.pointerPaint = new Paint();
        this.pointerPaint.setAntiAlias(true);
        this.pointerPaint.setTextSize(this.textSizeDial);
        this.pointerPaint.setTextAlign(Paint.Align.CENTER);
        this.pointerFontMetrics = this.pointerPaint.getFontMetrics();
        this.labelPaint = new Paint();
        this.labelPaint.setAntiAlias(true);
        this.labelPaint.setTextAlign(Paint.Align.CENTER);
        this.labelPaint.setFakeBoldText(true);
        this.labelPaint.setTextSize(this.labelTextSize);
        this.labelPaint.setColor(this.labelTextColor);
        this.labelFontMetrics = this.labelPaint.getFontMetrics();
        this.valPaint = new Paint();
        this.valPaint.setAntiAlias(true);
        this.valPaint.setTextAlign(Paint.Align.CENTER);
        this.valPaint.setTextSize(this.valTextSize);
        this.valPaint.setColor(this.valTextColor);
        this.valFontMetrics = this.valPaint.getFontMetrics();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBG(canvas);
        this.drawArc(canvas);
        this.drawPointerLine(canvas);
        this.drawValText(canvas);
        this.drawLabelText(canvas);
    }

    private void drawArc(Canvas canvas) {
        canvas.save();
        this.arcPaint.setStyle(Paint.Style.FILL);
        this.arcPaint.setShader(this.arcShader);
        canvas.drawArc(this.mArcRect, this.arcStartDegree, this.sweepAngle, true, this.arcPaint);
        this.arcPaint.setStyle(Paint.Style.STROKE);
        this.arcPaint.setColor(this.arcColor);
        this.arcPaint.setShader(null);
        this.arcPaint.setStrokeWidth(this.arcPaintStrokeWidth);
        canvas.drawArc(this.mArcRect, this.arcStartDegree, this.sweepAngle, false, this.arcPaint);
        this.arcPaint.setStrokeWidth(this.arcPaintStrokeWidth);
        canvas.drawArc(this.mCircleArcRect1, this.arcStartDegree, this.sweepAngle, false, this.arcPaint);
        canvas.drawArc(this.mCircleArcRect2, this.arcStartDegree, this.sweepAngle, false, this.arcPaint);
        this.arcPaint.setStrokeWidth(this.arcPaintStrokeWidth);
        canvas.translate((float)this.mCx, (float)this.mCy);
        canvas.rotate(this.arcStartDegree + this.sweepAngle);
        canvas.drawLine((float)this.radiusDial, 0.0f, (float)this.circleRadius2, 0.0f, this.arcPaint);
        canvas.restore();
    }

    private void drawLabelText(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.mCx, (float)this.mCy + (float)(this.bgRadius3 + this.circleRadius1) / 2.0f);
        int textBaseLine = (int)(0.0f + (this.labelFontMetrics.bottom - this.labelFontMetrics.top) / 2.0f - this.labelFontMetrics.bottom);
        canvas.drawText(this.labelText, 0.0f, (float)textBaseLine, this.labelPaint);
        canvas.restore();
    }

    private void drawValText(Canvas canvas) {
        if (this.valText != null) {
            canvas.save();
            canvas.translate((float)this.mCx, (float)this.mCy);
            int textBaseLine = (int)(0.0f + (this.valFontMetrics.bottom - this.valFontMetrics.top) / 2.0f - this.valFontMetrics.bottom);
            canvas.drawText(this.valText, 0.0f, (float)textBaseLine, this.valPaint);
            canvas.restore();
        }
    }

    private void drawPointerLine(Canvas c) {
        if (this.pLineCache == null) {
            this.pLineCache = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas pointerLineCacheCanvas = new Canvas(this.pLineCache);
            pointerLineCacheCanvas.translate((float)this.mCx, (float)this.mCy);
            pointerLineCacheCanvas.rotate(this.pointerLineDegree);
            int i = 0;
            while ((float)i <= this.valRange) {
                if (i < this.lowDialLimit) {
                    this.pointerPaint.setColor(this.colorDialLower);
                } else if (i <= this.highDialLimit) {
                    this.pointerPaint.setColor(this.colorDialMiddle);
                } else {
                    this.pointerPaint.setColor(this.colorDialHigh);
                }
                if (i % this.dialStep == 0) {
                    this.pointerPaint.setStrokeWidth(this.strokeLDial);
                    pointerLineCacheCanvas.drawLine((float)this.radiusDial, 0.0f, (float)(this.radiusDial - this.lengthLDial), 0.0f, this.pointerPaint);
                    this.drawPointerText(pointerLineCacheCanvas, this.decimalFormat.format(this.minVal + (float)i), i);
                } else {
                    this.pointerPaint.setStrokeWidth(this.strokeSDial);
                    int offset = (this.lengthLDial - this.lengthSDial) / 2;
                    pointerLineCacheCanvas.drawLine((float)(this.radiusDial - offset), 0.0f, (float)(this.radiusDial - this.lengthSDial), 0.0f, this.pointerPaint);
                }
                pointerLineCacheCanvas.rotate(this.sRoateDegree);
                ++i;
            }
        }
        c.drawBitmap(this.pLineCache, 0.0f, 0.0f, null);
    }

    private void drawPointerText(Canvas canvas, String text, int i) {
        canvas.save();
        int currentCenterX = (int)((float)(this.radiusDial - this.lengthLDial) - this.strokeLDial - this.pointerPaint.measureText(String.valueOf(text)) / 2.0f);
        canvas.translate((float)currentCenterX, 0.0f);
        canvas.rotate(360.0f - this.pointerLineDegree - (float)i * this.sRoateDegree);
        int textBaseLine = (int)(0.0f + (this.pointerFontMetrics.bottom - this.pointerFontMetrics.top) / 2.0f - this.pointerFontMetrics.bottom);
        canvas.drawText(text, 0.0f, (float)textBaseLine, this.pointerPaint);
        canvas.restore();
    }

    private void drawBG(Canvas canvas) {
        canvas.save();
        this.roundPaint.setStyle(Paint.Style.FILL);
        this.roundPaint.setColor(this.bgRound1);
        this.roundPaint.setStrokeWidth(0.0f);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.bgRadius1, this.roundPaint);
        this.roundPaint.setColor(this.bgRound2);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.bgRadius2, this.roundPaint);
        this.roundPaint.setColor(this.bgRound3);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.bgRadius3, this.roundPaint);
        this.roundPaint.setColor(this.bgRound4);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.bgRadius4, this.roundPaint);
        this.roundPaint.setColor(this.circle1);
        this.roundPaint.setStyle(Paint.Style.STROKE);
        this.roundPaint.setStrokeWidth(this.circleRadius1StrokeWidth);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.circleRadius1, this.roundPaint);
        this.roundPaint.setStrokeWidth(this.circleRadius2StrokeWidth);
        canvas.drawCircle((float)this.mCx, (float)this.mCy, (float)this.circleRadius2, this.roundPaint);
        canvas.restore();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        this.mWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        this.mHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        this.mCx = this.mWidth / 2;
        this.mCy = this.mHeight / 2;
        this.bgRadius1 = this.radius = Math.min(this.mWidth, this.mHeight) / 2;
        this.bgRadius2 = (int)((float)this.radius * 0.95f);
        this.bgRadius3 = (int)((float)this.radius * 0.88f);
        this.bgRadius4 = (int)((float)this.radius * 0.6f);
        this.circleRadius1 = (int)((float)this.radius * 0.64f);
        this.circleRadius2 = (int)((float)this.radius * 0.62f);
        this.radiusDial = this.bgRadius3;
        this.mArcRect.set((float)(this.mCx - this.radiusDial), (float)(this.mCy - this.radiusDial), (float)(this.mCx + this.radiusDial), (float)(this.mCy + this.radiusDial));
        this.mCircleArcRect1.set((float)(this.mCx - this.circleRadius1), (float)(this.mCy - this.circleRadius1), (float)(this.mCx + this.circleRadius1), (float)(this.mCy + this.circleRadius1));
        this.mCircleArcRect2.set((float)(this.mCx - this.circleRadius2), (float)(this.mCy - this.circleRadius2), (float)(this.mCx + this.circleRadius2), (float)(this.mCy + this.circleRadius2));
        this.arcShader = new RadialGradient((float)this.mCx, (float)this.mCy, (float)this.bgRadius2, this.colors, null, Shader.TileMode.REPEAT);
        this.arcLineShader = new LinearGradient((float)this.radiusDial, 0.0f, (float)this.circleRadius2, 0.0f, this.colorsArcLine, null, Shader.TileMode.REPEAT);
        this.pLineCache = null;
    }

    public void init(String formatter, float maxVal, float minVal, int dialStep, int lowDialLimit, int highDialLimit) {
        this.dialStep = dialStep;
        float drawDegree = 360.0f - (180.0f - this.pointerLineDegree) * 2.0f;
        this.maxVal = maxVal;
        this.minVal = minVal;
        this.valRange = maxVal - minVal;
        this.formatter = formatter;
        this.drawDialNum = (int)Math.ceil(this.valRange / (float)dialStep);
        this.stepDegree = drawDegree / (float)this.drawDialNum;
        this.lowDialLimit = (int)((float)lowDialLimit - minVal);
        this.highDialLimit = (int)((float)highDialLimit - minVal);
        this.sRoateDegree = this.stepDegree / (float)dialStep;
        this.invalidate();
    }

    public void updateVal(float val) {
        this.realVal = Math.max(Math.min(val, this.maxVal), this.minVal);
        this.valText = String.format(this.formatter, Float.valueOf(this.realVal));
        this.sweepAngle = (this.realVal - this.minVal) / this.valRange * (360.0f - (180.0f - this.pointerLineDegree) * 2.0f);
        this.invalidate();
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result;
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (View.MeasureSpec.getMode((int)measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.max(specSize, desired);
                break;
            }
            case 0x40000000: {
                result = specSize;
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    private float dp2px(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public void config(Config cfg) {
        int[] nArray;
        int[] nArray2;
        this.bgRound1 = cfg.bgRound1;
        this.bgRound2 = cfg.bgRound2;
        this.bgRound3 = cfg.bgRound3;
        this.bgRound4 = cfg.bgRound4;
        this.circle1 = cfg.circle1;
        this.textSizeDial = this.dp2px(cfg.textSizeDial);
        this.maxVal = cfg.maxVal;
        this.minVal = cfg.minVal;
        this.lowDialLimit = cfg.lowDialLimit;
        this.highDialLimit = cfg.highDialLimit;
        this.colorDialLower = cfg.colorDialLower;
        this.colorDialMiddle = cfg.colorDialMiddle;
        this.colorDialHigh = cfg.colorDialHigh;
        this.lengthLDial = cfg.lengthLDial;
        this.lengthSDial = cfg.lengthSDial;
        this.strokeLDial = cfg.strokeLDial;
        this.strokeSDial = cfg.strokeSDial;
        this.circleRadius1StrokeWidth = cfg.circleRadius1StrokeWidth;
        this.circleRadius2StrokeWidth = cfg.circleRadius2StrokeWidth;
        this.arcStartDegree = this.pointerLineDegree = cfg.pointerLineDegree;
        this.valTextSize = this.dp2px(cfg.valTextSize);
        this.valTextColor = cfg.valTextColor;
        this.labelText = cfg.labelText;
        this.labelTextSize = this.dp2px(cfg.labelTextSize);
        this.labelTextColor = cfg.labelTextColor;
        this.arcPaintStrokeWidth = cfg.arcPaintStrokeWidth;
        this.arcColor = cfg.arcColor;
        if (cfg.colors != null) {
            nArray2 = cfg.colors;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 0;
            nArray3[2] = 0;
            nArray2 = nArray3;
            nArray3[3] = cfg.arcColor;
        }
        this.colors = nArray2;
        if (cfg.colorsArcLine != null) {
            nArray = cfg.colorsArcLine;
        } else {
            int[] nArray4 = new int[3];
            nArray4[0] = cfg.arcColor;
            nArray4[1] = cfg.arcColor;
            nArray = nArray4;
            nArray4[2] = 0;
        }
        this.colorsArcLine = nArray;
        this.formatter = cfg.formatter;
        this.drawDialNum = cfg.drawDialNum;
        this.dialStep = cfg.dialStep;
        this.decimalFormat = cfg.decimalFormat;
        this.init();
        this.invalidate();
    }

    public static class Config {
        public int bgRound1 = Color.parseColor((String)"#99122a73");
        public int bgRound2 = Color.parseColor((String)"#66122a73");
        public int bgRound3 = Color.parseColor((String)"#22142f80");
        public int bgRound4 = Color.parseColor((String)"#0e2267");
        public int circle1 = Color.parseColor((String)"#0d1d4c");
        public float textSizeDial = 12.0f;
        public float maxVal = 150.0f;
        public float minVal = -50.0f;
        public int lowDialLimit = 20;
        public int highDialLimit = 80;
        public int colorDialLower = Color.parseColor((String)"#00faff");
        public int colorDialMiddle = -16711936;
        public int colorDialHigh = -65536;
        public int lengthLDial = 16;
        public int lengthSDial = 8;
        public float strokeLDial = 3.0f;
        public float strokeSDial = 1.0f;
        public float circleRadius1StrokeWidth = 2.0f;
        public float circleRadius2StrokeWidth = 4.0f;
        public float pointerLineDegree = 135.0f;
        public float valTextSize = 30.0f;
        public int valTextColor = -1;
        public String labelText = "";
        public float labelTextSize = 14.0f;
        public int labelTextColor = -1;
        public float arcPaintStrokeWidth = 2.0f;
        public int arcColor = Color.parseColor((String)"#f6a800");
        public int[] colors;
        public int[] colorsArcLine;
        public String formatter = "%.0f";
        public int drawDialNum = 100;
        public int dialStep = 10;
        public DecimalFormat decimalFormat = new DecimalFormat(".0");
    }
}

