/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.core.content.res.ResourcesCompat;
import java.util.ArrayList;
import java.util.List;
import org.tcshare.androidutils.R;
import org.tcshare.utils.DensityUtil;
import org.tcshare.utils.RandomUtils;
import org.tcshare.widgets.BezierEvaluator;
import org.tcshare.widgets.BezierListener;

public class FavorLayout
extends RelativeLayout {
    private static final String TAG = FavorLayout.class.getSimpleName();
    private int iHeight = 120;
    private int iWidth = 120;
    private int mHeight;
    private int mWidth;
    private RelativeLayout.LayoutParams lp;
    private List<Drawable> loves;
    private final List<Interpolator> interpolates = new ArrayList<Interpolator>(){
        {
            this.add(new LinearInterpolator());
            this.add(new DecelerateInterpolator());
            this.add(new AccelerateDecelerateInterpolator());
        }
    };
    private PointF startPoint = new PointF();
    private PointF anchorPoint;
    private View anchorView;
    private int favorWidth = -1;
    private int favorHeight = -1;
    private boolean stop = false;

    public FavorLayout(Context context) {
        super(context);
        this.init();
    }

    public FavorLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FavorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        this.startPoint.set((float)(this.mWidth - this.iWidth) / 2.0f, (float)(this.mHeight - this.iHeight));
    }

    private void init() {
        this.lp = new RelativeLayout.LayoutParams(this.iWidth, this.iHeight);
        this.lp.addRule(14, -1);
        this.lp.addRule(12, -1);
        final Resources res = this.getResources();
        this.loves = new ArrayList<Drawable>(){
            {
                this.add(ResourcesCompat.getDrawable((Resources)res, (int)R.mipmap.love_a, null));
                this.add(ResourcesCompat.getDrawable((Resources)res, (int)R.mipmap.love_b, null));
                this.add(ResourcesCompat.getDrawable((Resources)res, (int)R.mipmap.love_c, null));
                this.add(ResourcesCompat.getDrawable((Resources)res, (int)R.mipmap.love_d, null));
                this.add(ResourcesCompat.getDrawable((Resources)res, (int)R.mipmap.love_e, null));
            }
        };
    }

    public void setAnchor(View view) {
        this.anchorView = view;
        this.resetAnchorPoint();
    }

    private void resetAnchorPoint() {
        if (this.anchorView != null) {
            this.anchorView.post(new Runnable(){

                @Override
                public void run() {
                    int[] outLocation = new int[2];
                    FavorLayout.this.anchorView.getLocationOnScreen(outLocation);
                    float x = (float)outLocation[0] + (float)(FavorLayout.this.anchorView.getWidth() - FavorLayout.this.iWidth) / 2.0f;
                    float y = (float)outLocation[1] - (float)(FavorLayout.this.anchorView.getHeight() - FavorLayout.this.iHeight) / 2.0f;
                    FavorLayout.this.anchorPoint = new PointF(x, y);
                }
            });
        }
    }

    public void addFavor() {
        if (this.stop) {
            return;
        }
        ImageView imageView = new ImageView(this.getContext());
        imageView.setImageDrawable(RandomUtils.getRandomElement(this.loves));
        if (this.anchorPoint == null) {
            imageView.setLayoutParams((ViewGroup.LayoutParams)this.lp);
        } else {
            imageView.setX(this.anchorPoint.x - this.getX());
            imageView.setY(this.anchorPoint.y - this.getY());
        }
        this.addView((View)imageView);
        Log.d((String)TAG, (String)("addFavor: add\u540e\u5b50view\u6570:" + this.getChildCount()));
        Animator set = this.getAnimator((View)imageView);
        set.addListener((Animator.AnimatorListener)new AnimEndListener((View)imageView));
        set.start();
    }

    private Animator getAnimator(View target) {
        AnimatorSet set = this.getEnterAnimator(target);
        ValueAnimator bezierValueAnimator = this.getBezierValueAnimator(target);
        AnimatorSet finalSet = new AnimatorSet();
        finalSet.playSequentially(new Animator[]{set});
        finalSet.playSequentially(new Animator[]{set, bezierValueAnimator});
        finalSet.setInterpolator((TimeInterpolator)RandomUtils.getRandomElement(this.interpolates));
        finalSet.setTarget((Object)target);
        return finalSet;
    }

    private AnimatorSet getEnterAnimator(View target) {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (Property)View.ALPHA, (float[])new float[]{0.2f, 1.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (Property)View.SCALE_X, (float[])new float[]{0.2f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (Property)View.SCALE_Y, (float[])new float[]{0.2f, 1.0f});
        AnimatorSet enter = new AnimatorSet();
        enter.setDuration(500L);
        enter.setInterpolator((TimeInterpolator)new LinearInterpolator());
        enter.playTogether(new Animator[]{alpha, scaleX, scaleY});
        enter.setTarget((Object)target);
        return enter;
    }

    public void setFavorWidthHeight(int width, int height) {
        this.favorWidth = DensityUtil.dp2px(this.getContext(), width);
        this.favorHeight = DensityUtil.dp2px(this.getContext(), height);
    }

    private PointF getPointLow() {
        PointF pointF = new PointF();
        if (this.anchorView != null && this.favorWidth != -1 && this.favorHeight != -1 && this.anchorPoint != null) {
            float x = this.anchorPoint.x - this.getX();
            float y = this.anchorPoint.y - this.getY();
            pointF.x = x - (float)this.favorWidth / 2.0f + (float)RandomUtils.getRandomInt(this.favorWidth);
            pointF.y = y - (float)this.favorHeight / 4.0f - (float)RandomUtils.getRandomInt(this.favorHeight / 4);
        } else {
            pointF.x = RandomUtils.getRandomInt(this.mWidth - 100);
            pointF.y = (float)RandomUtils.getRandomInt(this.mHeight - 100) / 2.0f;
        }
        return pointF;
    }

    private PointF getPointHeight() {
        PointF pointF = new PointF();
        if (this.anchorView != null && this.favorWidth != -1 && this.favorHeight != -1 && this.anchorPoint != null) {
            float x = this.anchorPoint.x - this.getX();
            float y = this.anchorPoint.y - this.getY();
            pointF.x = x - (float)this.favorWidth / 2.0f + (float)RandomUtils.getRandomInt(this.favorWidth);
            pointF.y = y - (float)this.favorHeight / 2.0f - (float)RandomUtils.getRandomInt(this.favorHeight / 4);
        } else {
            pointF.x = RandomUtils.getRandomInt(this.mWidth - 100);
            pointF.y = RandomUtils.getRandomInt(this.mHeight - 100);
        }
        return pointF;
    }

    private PointF getEndPoint() {
        PointF pointF = new PointF();
        if (this.anchorView != null && this.favorWidth != -1 && this.favorHeight != -1 && this.anchorPoint != null) {
            float x = this.anchorPoint.x - this.getX();
            float y = this.anchorPoint.y - this.getY();
            pointF.x = x - (float)this.favorWidth / 2.0f + (float)RandomUtils.getRandomInt(this.favorWidth);
            pointF.y = y - (float)this.favorHeight;
        } else {
            pointF.set((float)RandomUtils.getRandomInt(this.getWidth()), 0.0f);
        }
        return pointF;
    }

    private ValueAnimator getBezierValueAnimator(View target) {
        BezierEvaluator evaluator = new BezierEvaluator(this.getPointLow(), this.getPointHeight());
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{this.anchorPoint == null ? this.startPoint : new PointF(this.anchorPoint.x - this.getX(), this.anchorPoint.y - this.getY()), this.getEndPoint()});
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new BezierListener(target));
        animator.setTarget((Object)target);
        animator.setDuration(3000L);
        return animator;
    }

    public void setFavors(List<Drawable> items) {
        this.loves.clear();
        this.loves.addAll(items);
        if (items.size() == 0) {
            throw new UnsupportedOperationException("\u70b9\u8d5e\u6548\u679c\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.iWidth = items.get(0).getIntrinsicWidth();
        this.iHeight = items.get(0).getIntrinsicHeight();
        this.startPoint = new PointF((float)(this.mWidth - this.iWidth) / 2.0f, (float)(this.mHeight - this.iHeight));
        this.resetAnchorPoint();
    }

    public void setStat(boolean stop) {
        this.stop = stop;
    }

    private class AnimEndListener
    extends AnimatorListenerAdapter {
        private final View target;

        public AnimEndListener(View target) {
            this.target = target;
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            FavorLayout.this.removeView(this.target);
            Log.v((String)TAG, (String)("removeView\u540e\u5b50view\u6570:" + FavorLayout.this.getChildCount()));
        }
    }
}

