/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public abstract class EndLessOnScrollListener
extends RecyclerView.OnScrollListener {
    private LinearLayoutManager mLinearLayoutManager;
    private int currentPage = 0;
    private int totalItemCount;
    private int previousTotal = 0;
    private int visibleItemCount;
    private int firstVisibleItem;
    private boolean loading = true;

    public EndLessOnScrollListener(LinearLayoutManager linearLayoutManager) {
        this.mLinearLayoutManager = linearLayoutManager;
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        this.visibleItemCount = recyclerView.getChildCount();
        this.totalItemCount = this.mLinearLayoutManager.getItemCount();
        this.firstVisibleItem = this.mLinearLayoutManager.findFirstVisibleItemPosition();
        if (this.loading && this.totalItemCount > this.previousTotal) {
            this.loading = false;
            this.previousTotal = this.totalItemCount;
        }
        if (!this.loading && this.totalItemCount - this.visibleItemCount <= this.firstVisibleItem) {
            ++this.currentPage;
            this.onLoadMore(this.currentPage);
            this.loading = true;
        }
    }

    public abstract void onLoadMore(int var1);
}

