/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.widgets;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Handler;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.core.content.ContextCompat;
import org.tcshare.androidutils.R;

public class DashSpinner
extends View {
    private static final float DEFAULT_START_SPEED = 20.0f;
    private static final float DEFAULT_ARC_WIDTH = 6.0f;
    private static final float DEFAULT_RING_WIDTH = 2.0f;
    private static final int CIRCULAR_FACTOR = 360;
    private static final float ARC_START_POSITION = 270.0f;
    private static final float DEFAULT_ARC_LENGTH = 90.0f;
    private static final int DEFAULT_MAX_TEXT_SIZE = 40;
    private static final int TEXT_PADDING = 8;
    private static final int TRANSITION_ANIM_DURATION = 400;
    private static final float TRANSITION_CAT_START_VAL = 1.0f;
    private static final float TRANSITION_CAT_END_VAL = 0.0f;
    private static final float STATUS_SYMBOL_WIDTH_PERCENT = 0.5f;
    private static final float TEXT_SCALE_DOWN_PERCENT_VALUE = 0.1f;
    private static final float STATE_LINE_STROKE = 2.0f;
    private static final float TICK_SHORT_ARM_RATIO_PERCENT = 0.25f;
    private static final float TICK_LONG_ARM_RATIO_PERCENT = 0.75f;
    private static final float ARM_ANGLE = 45.0f;
    private static final float TICK_SHORT_ARM_ANGLE_RADIANS = 45.0f;
    private static final float TICK_LONG_ARM_ANGLE_RADIANS = -45.0f;
    private static final float UNKNOWN_DOT_DISTANCE = 10.0f;
    private static final float UNKNOWN_ROTATION_ANGLE = 90.0f;
    private static final int MAX_ALPHA = 255;
    private DASH_MODE mCurrentDashMode = DASH_MODE.NONE;
    private DASH_MODE mNextDashMode = DASH_MODE.NONE;
    private String msProgressText = "";
    private int mOuterRingColor = 0;
    private int mArcColor = 0;
    private int mInnerCircleSuccessColor = 0;
    private int mInnerCircleFailureColor = 0;
    private int mInnerCircleUnknownColor = 0;
    private int mTextColorFrom = 0;
    private int mTextColorTo = 0;
    private int mnMaxTextSize = 40;
    private final Paint mPaint = new Paint(1);
    private TextPaint mTextPaint = new TextPaint(1);
    private float mnArcWidth = 0.0f;
    private float mnRingWidth = 0.0f;
    private final RectF mArcRect = new RectF();
    private float mnIndeterminateStartPosition = 0.0f;
    private float mnStartSpeed = 0.0f;
    private float mnProgress = 0.0f;
    private SpannableStringBuilder mStringBuilder = new SpannableStringBuilder((CharSequence)"");
    private DynamicLayout mDynamicLayout = null;
    private boolean mbShowProgress = false;
    private float mnArcLength = 0.0f;
    private ValueAnimator mTransitionTextAndCircleValueAnimator = null;
    private ValueAnimator mTransitionLineWidthValueAnimator = null;
    private ValueAnimator mTransitionToStateValueAnimator = null;
    private float mnTransitionProgress = 0.0f;
    private int mnSize = 0;
    private int mnRingRadius = 0;
    private int mnInnerCircleRadius = 0;
    private int mnViewCenter = 0;
    private float mnProgressRadius = 0.0f;
    private float mnLineWidth = 0.0f;
    private OnDownloadIntimationListener mOnDownloadIntimationListener = null;
    private Handler mCompletionHandler = new Handler();

    public DashSpinner(Context context) {
        this(context, null);
    }

    public DashSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DashSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DashSpinner, 0, 0);
            this.mOuterRingColor = a.getColor(R.styleable.DashSpinner_outerRingColor, ContextCompat.getColor((Context)context, (int)17170451));
            this.mInnerCircleSuccessColor = a.getColor(R.styleable.DashSpinner_innerCircleSuccessColor, ContextCompat.getColor((Context)context, (int)17170452));
            this.mInnerCircleFailureColor = a.getColor(R.styleable.DashSpinner_innerCircleFailureColor, ContextCompat.getColor((Context)context, (int)0x1060016));
            this.mInnerCircleUnknownColor = a.getColor(R.styleable.DashSpinner_innerCircleUnknownColor, ContextCompat.getColor((Context)context, (int)17170456));
            this.mArcColor = a.getColor(R.styleable.DashSpinner_arcColor, ContextCompat.getColor((Context)context, (int)17170443));
            this.mTextColorFrom = a.getColor(R.styleable.DashSpinner_textColorFrom, ContextCompat.getColor((Context)context, (int)17170444));
            this.mTextColorTo = a.getColor(R.styleable.DashSpinner_textColorTo, ContextCompat.getColor((Context)context, (int)17170443));
            this.mnIndeterminateStartPosition = a.getFloat(R.styleable.DashSpinner_arcStartPosition, 270.0f);
            this.mnStartSpeed = a.getFloat(R.styleable.DashSpinner_arcSweepSpeed, 20.0f);
            this.mnArcWidth = a.getDimension(R.styleable.DashSpinner_arcWidth, this.d2x(6.0f));
            this.mnRingWidth = a.getDimension(R.styleable.DashSpinner_outerRingWidth, this.d2x(2.0f));
            this.mnMaxTextSize = (int)a.getDimension(R.styleable.DashSpinner_maxProgressTextSize, this.d2x(40.0f));
            this.mbShowProgress = a.getBoolean(R.styleable.DashSpinner_showProgressText, false);
            this.mnArcLength = a.getFloat(R.styleable.DashSpinner_arcLength, 90.0f);
            a.recycle();
        }
        this.mTextPaint.setTextSize((float)this.mnMaxTextSize);
        this.mTextPaint.setColor(this.mTextColorFrom);
        this.mTextPaint.setTypeface(Typeface.create((String)"sans-serif-light", (int)0));
        this.setLayerType(1, this.mPaint);
    }

    public void setOnDownloadIntimationListener(OnDownloadIntimationListener listener) {
        this.mOnDownloadIntimationListener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initializeValues();
        this.mDynamicLayout = new DynamicLayout((CharSequence)this.mStringBuilder, (CharSequence)this.mStringBuilder, this.mTextPaint, w, Layout.Alignment.ALIGN_CENTER, 1.0f, 1.0f, true);
    }

    protected void onDraw(Canvas canvas) {
        this.resetPaint();
        this.drawOuterRing(canvas);
        this.drawInnerCircle(canvas);
        this.drawStateContent(canvas);
        this.drawArc(canvas);
    }

    private void resetPaint() {
        this.mPaint.reset();
        this.mPaint.setAntiAlias(true);
    }

    public void resetValues() {
        this.mnSize = 0;
        this.mnRingRadius = 0;
        this.mnInnerCircleRadius = 0;
        this.mnViewCenter = 0;
        this.mnProgress = 0.0f;
        this.mnTransitionProgress = 0.0f;
        this.mTransitionLineWidthValueAnimator = null;
        this.mTransitionTextAndCircleValueAnimator = null;
        this.mTransitionToStateValueAnimator = null;
        this.mCurrentDashMode = DASH_MODE.NONE;
        this.mNextDashMode = DASH_MODE.NONE;
        this.initializeValues();
    }

    private void initializeValues() {
        this.mnSize = Math.min(this.getMeasuredHeight(), this.getMeasuredWidth());
        this.mnRingRadius = (int)((float)this.mnSize - this.mnRingWidth) / 2;
        this.mnInnerCircleRadius = (int)((float)this.mnSize - this.mnRingWidth * 2.0f) / 2;
        this.mnViewCenter = this.mnSize / 2;
        this.mnLineWidth = 0.5f * (float)this.mnSize;
    }

    private void drawOuterRing(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mnRingWidth);
        this.mPaint.setColor(this.mOuterRingColor);
        canvas.drawCircle((float)this.mnViewCenter, (float)this.mnViewCenter, (float)this.mnRingRadius, this.mPaint);
    }

    private void drawInnerCircle(Canvas canvas) {
        float nDrawRadius = 0.0f;
        this.mPaint.setStyle(Paint.Style.FILL);
        switch (this.mCurrentDashMode) {
            case DOWNLOAD: {
                this.mPaint.setColor(this.mInnerCircleSuccessColor);
                this.mPaint.setAlpha(this.getInnerCircleAlpha());
                float nCurrentRadius = (float)this.mnInnerCircleRadius * this.mnProgress;
                nDrawRadius = this.mnProgressRadius = nCurrentRadius < (float)this.mnInnerCircleRadius ? nCurrentRadius : (float)this.mnInnerCircleRadius;
                break;
            }
            case TRANSITION_TEXT_AND_CIRCLE: 
            case TRANSITION_LINE: {
                if (this.mNextDashMode.equals((Object)DASH_MODE.FAILURE) || this.mNextDashMode.equals((Object)DASH_MODE.UNKNOWN)) {
                    this.mPaint.setColor(this.mNextDashMode.equals((Object)DASH_MODE.FAILURE) ? this.mInnerCircleFailureColor : this.mInnerCircleUnknownColor);
                    if (this.mCurrentDashMode.equals((Object)DASH_MODE.TRANSITION_TEXT_AND_CIRCLE)) {
                        float nInverseTransition = 1.0f - this.mnTransitionProgress;
                        nDrawRadius = this.mnProgressRadius + ((float)this.mnInnerCircleRadius - this.mnProgressRadius) * nInverseTransition;
                        this.mPaint.setAlpha(this.getInnerCircleAlpha() + (int)((float)(255 - this.getInnerCircleAlpha()) * nInverseTransition));
                        break;
                    }
                    this.mPaint.setAlpha(255);
                    nDrawRadius = this.mnInnerCircleRadius;
                    break;
                }
                this.mPaint.setColor(this.mInnerCircleSuccessColor);
                this.mPaint.setAlpha(255);
                nDrawRadius = this.mnInnerCircleRadius;
                break;
            }
            case SUCCESS: {
                this.mPaint.setColor(this.mInnerCircleSuccessColor);
                this.mPaint.setAlpha(255);
                nDrawRadius = this.mnInnerCircleRadius;
                break;
            }
            case FAILURE: {
                this.mPaint.setColor(this.mInnerCircleFailureColor);
                this.mPaint.setAlpha(255);
                nDrawRadius = this.mnInnerCircleRadius;
                break;
            }
            case UNKNOWN: {
                this.mPaint.setColor(this.mInnerCircleUnknownColor);
                this.mPaint.setAlpha(255);
                nDrawRadius = this.mnInnerCircleRadius;
            }
        }
        canvas.drawCircle((float)this.mnViewCenter, (float)this.mnViewCenter, nDrawRadius, this.mPaint);
        this.mPaint.setAlpha(255);
    }

    private int getInnerCircleAlpha() {
        int nCurrAlpha = (int)(255.0f * this.mnProgress);
        nCurrAlpha = nCurrAlpha < 0 ? 0 : (nCurrAlpha > 255 ? 255 : nCurrAlpha);
        return nCurrAlpha;
    }

    private void drawStateContent(Canvas canvas) {
        float appropriateFontSize = 0.0f;
        switch (this.mCurrentDashMode) {
            case DOWNLOAD: 
            case TRANSITION_TEXT_AND_CIRCLE: {
                if (this.mCurrentDashMode.equals((Object)DASH_MODE.TRANSITION_TEXT_AND_CIRCLE) && this.mnTransitionProgress < 0.1f) {
                    this.mPaint.setColor(this.mTextColorTo);
                    canvas.drawCircle((float)this.mnViewCenter, (float)this.mnViewCenter, this.d2x(2.0f) / 2.0f, this.mPaint);
                    break;
                }
                if (!this.mbShowProgress) break;
                float nTextWidth = (this.mCurrentDashMode.equals((Object)DASH_MODE.DOWNLOAD) ? this.mnProgressRadius * 2.0f : this.mnProgressRadius * this.mnTransitionProgress * 2.0f) - this.d2x(8.0f);
                appropriateFontSize = DashSpinner.getSingleLineTextSize(this.msProgressText, this.mTextPaint, nTextWidth, 0.0f, this.mnMaxTextSize, 0.5f, this.getResources().getDisplayMetrics());
                this.msProgressText = (int)(this.mnProgress * 100.0f) + "%";
                this.mTextPaint.setTextSize(appropriateFontSize);
                this.mTextPaint.setColor(this.mCurrentDashMode.equals((Object)DASH_MODE.DOWNLOAD) ? this.blendColors(this.mTextColorFrom, this.mTextColorTo, this.mnProgress) : this.mTextColorTo);
                this.mStringBuilder.replace(0, this.mStringBuilder.length(), (CharSequence)this.msProgressText);
                canvas.save();
                canvas.translate((float)(this.mnViewCenter - this.mDynamicLayout.getWidth() / 2), (float)(this.mnViewCenter - this.mDynamicLayout.getHeight() / 2));
                this.mDynamicLayout.draw(canvas);
                canvas.restore();
                break;
            }
            case TRANSITION_LINE: {
                this.mPaint.setColor(this.mTextColorTo);
                this.mPaint.setStrokeWidth(this.d2x(2.0f));
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
                float nDiffLength = this.mnLineWidth * this.mnTransitionProgress;
                if (this.mNextDashMode.equals((Object)DASH_MODE.SUCCESS)) {
                    float nStart = (float)this.mnViewCenter - 0.25f * nDiffLength;
                    float nEnd = (float)this.mnViewCenter + 0.75f * nDiffLength;
                    canvas.drawLine(nStart, (float)this.mnViewCenter, nEnd, (float)this.mnViewCenter, this.mPaint);
                    break;
                }
                canvas.drawLine((float)this.mnViewCenter - nDiffLength / 2.0f, (float)this.mnViewCenter, (float)this.mnViewCenter + nDiffLength / 2.0f, (float)this.mnViewCenter, this.mPaint);
                break;
            }
            case SUCCESS: {
                this.mPaint.setColor(this.mTextColorTo);
                this.mPaint.setStrokeWidth(this.d2x(2.0f));
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
                float nShortArmLength = 0.25f * this.mnLineWidth;
                float nLongArmLength = 0.75f * this.mnLineWidth;
                float nStartShortArmX = (float)((double)this.mnViewCenter - (double)nShortArmLength * Math.cos(Math.toRadians(45.0f * this.mnTransitionProgress)));
                float nEndShortArmY = (float)((double)this.mnViewCenter + (double)nShortArmLength * Math.sin(Math.toRadians(45.0f * this.mnTransitionProgress)));
                float nEndLongArmX = (float)((double)nStartShortArmX + (double)nLongArmLength * Math.cos(Math.toRadians(-45.0f * this.mnTransitionProgress)));
                float nEndLongArmY = (float)((double)nEndShortArmY + (double)nLongArmLength * Math.sin(Math.toRadians(-45.0f * this.mnTransitionProgress)));
                canvas.drawLine(nStartShortArmX, (float)this.mnViewCenter, (float)this.mnViewCenter, nEndShortArmY, this.mPaint);
                canvas.drawLine((float)this.mnViewCenter, nEndShortArmY, nEndLongArmX, nEndLongArmY, this.mPaint);
                break;
            }
            case FAILURE: {
                this.mPaint.setColor(this.mTextColorTo);
                this.mPaint.setStrokeWidth(this.d2x(2.0f));
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
                float nArmLength = this.mnLineWidth / 2.0f;
                float nQuadFourX = (float)((double)this.mnViewCenter + (double)nArmLength * Math.cos(Math.toRadians(45.0f * this.mnTransitionProgress)));
                float nQuadFourY = (float)((double)this.mnViewCenter + (double)nArmLength * Math.sin(Math.toRadians(45.0f * this.mnTransitionProgress)));
                float nQuadOneX = (float)((double)this.mnViewCenter + (double)nArmLength * Math.cos(Math.toRadians(-45.0f * this.mnTransitionProgress)));
                float nQuadOneY = (float)((double)this.mnViewCenter + (double)nArmLength * Math.sin(Math.toRadians(-45.0f * this.mnTransitionProgress)));
                float nQuadThreeX = (float)((double)this.mnViewCenter + (double)nArmLength * Math.cos(Math.toRadians(180.0f - 45.0f * this.mnTransitionProgress)));
                float nQuadThreeY = (float)((double)this.mnViewCenter + (double)nArmLength * Math.sin(Math.toRadians(180.0f - 45.0f * this.mnTransitionProgress)));
                float nQuadTwoX = (float)((double)this.mnViewCenter + (double)nArmLength * Math.cos(Math.toRadians(180.0f - -45.0f * this.mnTransitionProgress)));
                float nQuadTwoY = (float)((double)this.mnViewCenter + (double)nArmLength * Math.sin(Math.toRadians(180.0f - -45.0f * this.mnTransitionProgress)));
                canvas.drawLine((float)this.mnViewCenter, (float)this.mnViewCenter, nQuadOneX, nQuadOneY, this.mPaint);
                canvas.drawLine((float)this.mnViewCenter, (float)this.mnViewCenter, nQuadTwoX, nQuadTwoY, this.mPaint);
                canvas.drawLine((float)this.mnViewCenter, (float)this.mnViewCenter, nQuadThreeX, nQuadThreeY, this.mPaint);
                canvas.drawLine((float)this.mnViewCenter, (float)this.mnViewCenter, nQuadFourX, nQuadFourY, this.mPaint);
                break;
            }
            case UNKNOWN: {
                this.mPaint.setColor(this.mTextColorTo);
                this.mPaint.setStrokeWidth(this.d2x(2.0f));
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
                float nDotRadius = 1.0f;
                float nDotDistance = this.d2x(10.0f);
                float nArmLength = this.mnLineWidth / 2.0f;
                float nQuadOneX = (float)((double)this.mnViewCenter + (double)nArmLength * Math.cos(Math.toRadians(-90.0f * this.mnTransitionProgress)));
                float nQuadOneY = (float)((double)this.mnViewCenter + (double)nArmLength * Math.sin(Math.toRadians(-90.0f * this.mnTransitionProgress)));
                float nQuadThreeX = (float)((double)this.mnViewCenter + (double)nArmLength * Math.cos(Math.toRadians(180.0f - 90.0f * this.mnTransitionProgress)));
                float nQuadThreeY = (float)((double)this.mnViewCenter + (double)nArmLength * Math.sin(Math.toRadians(180.0f - 90.0f * this.mnTransitionProgress)));
                float nDotX = (float)((double)this.mnViewCenter + (double)(nArmLength + nDotDistance * this.mnTransitionProgress) * Math.cos(Math.toRadians(180.0f - 90.0f * this.mnTransitionProgress)));
                float nDotY = (float)((double)this.mnViewCenter + (double)(nArmLength + nDotDistance * this.mnTransitionProgress) * Math.sin(Math.toRadians(180.0f - 90.0f * this.mnTransitionProgress)));
                canvas.drawLine((float)this.mnViewCenter, (float)this.mnViewCenter, nQuadOneX, nQuadOneY, this.mPaint);
                canvas.drawLine((float)this.mnViewCenter, (float)this.mnViewCenter, nQuadThreeX, nQuadThreeY, this.mPaint);
                canvas.drawCircle(nDotX, nDotY, nDotRadius, this.mPaint);
            }
        }
    }

    private void drawArc(Canvas canvas) {
        if (this.mCurrentDashMode.equals((Object)DASH_MODE.DOWNLOAD)) {
            this.mnIndeterminateStartPosition += (1.0f - this.mnProgress) * this.mnStartSpeed;
            if (this.mnIndeterminateStartPosition > 360.0f || this.mnIndeterminateStartPosition < 0.0f) {
                this.mnIndeterminateStartPosition = 0.0f;
            }
            Rect currRect = new Rect();
            this.getLocalVisibleRect(currRect);
            float nRingBoundaryInner = (float)this.mnRingRadius - this.mnRingWidth / 2.0f - this.mnArcWidth / 2.0f;
            this.mArcRect.set((float)this.mnViewCenter - nRingBoundaryInner, (float)this.mnViewCenter - nRingBoundaryInner, (float)this.mnViewCenter + nRingBoundaryInner, (float)this.mnViewCenter + nRingBoundaryInner);
            this.mPaint.setColor(this.mArcColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mnArcWidth);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            canvas.drawArc(this.mArcRect, this.mnIndeterminateStartPosition, this.mnArcLength, false, this.mPaint);
        }
    }

    public static float getSingleLineTextSize(String text, TextPaint paint, float targetWidth, float low, float high, float precision, DisplayMetrics metrics) {
        float mid = (low + high) / 2.0f;
        paint.setTextSize(TypedValue.applyDimension((int)0, (float)mid, (DisplayMetrics)metrics));
        float maxLineWidth = paint.measureText(text);
        if (high - low < precision) {
            return low;
        }
        if (maxLineWidth > targetWidth) {
            return DashSpinner.getSingleLineTextSize(text, paint, targetWidth, low, mid, precision, metrics);
        }
        if (maxLineWidth < targetWidth) {
            return DashSpinner.getSingleLineTextSize(text, paint, targetWidth, mid, high, precision, metrics);
        }
        return mid;
    }

    private float d2x(float size) {
        return TypedValue.applyDimension((int)1, (float)size, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    private int blendColors(int nFromColor, int nToColor, float nProgress) {
        float nInverseProgress = 1.0f - nProgress;
        float r = (float)Color.red((int)nToColor) * nProgress + (float)Color.red((int)nFromColor) * nInverseProgress;
        float g = (float)Color.green((int)nToColor) * nProgress + (float)Color.green((int)nFromColor) * nInverseProgress;
        float b = (float)Color.blue((int)nToColor) * nProgress + (float)Color.blue((int)nFromColor) * nInverseProgress;
        return Color.rgb((int)((int)r), (int)((int)g), (int)((int)b));
    }

    public void setProgress(float nProgress) {
        if (this.mCurrentDashMode.equals((Object)DASH_MODE.NONE) || this.mCurrentDashMode.equals((Object)DASH_MODE.DOWNLOAD)) {
            this.mCurrentDashMode = DASH_MODE.DOWNLOAD;
            this.mnProgress = nProgress < 0.0f ? 0.0f : (nProgress > 1.0f ? 1.0f : nProgress);
            this.postInvalidate();
        }
    }

    public void showSuccess() {
        this.mCurrentDashMode = DASH_MODE.TRANSITION_TEXT_AND_CIRCLE;
        this.mNextDashMode = DASH_MODE.SUCCESS;
        this.startCircleAndTextTransitionAnimation();
    }

    public void showFailure() {
        this.mCurrentDashMode = DASH_MODE.TRANSITION_TEXT_AND_CIRCLE;
        this.mNextDashMode = DASH_MODE.FAILURE;
        this.startCircleAndTextTransitionAnimation();
    }

    public void showUnknown() {
        this.mCurrentDashMode = DASH_MODE.TRANSITION_TEXT_AND_CIRCLE;
        this.mNextDashMode = DASH_MODE.UNKNOWN;
        this.startCircleAndTextTransitionAnimation();
    }

    private void startCircleAndTextTransitionAnimation() {
        if (this.mTransitionTextAndCircleValueAnimator == null) {
            this.mTransitionTextAndCircleValueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mnTransitionProgress});
            this.mTransitionTextAndCircleValueAnimator.setFloatValues(new float[]{1.0f, 0.0f});
            this.mTransitionTextAndCircleValueAnimator.setDuration(400L);
            this.mTransitionTextAndCircleValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mTransitionTextAndCircleValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    DashSpinner.this.mnTransitionProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    DashSpinner.this.postInvalidate();
                }
            });
            this.mTransitionTextAndCircleValueAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    DashSpinner.this.startLineScaleTransitionAnimation();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else if (this.mTransitionTextAndCircleValueAnimator.isRunning()) {
            this.mTransitionTextAndCircleValueAnimator.cancel();
        }
        this.mTransitionTextAndCircleValueAnimator.start();
    }

    private void startLineScaleTransitionAnimation() {
        this.mCurrentDashMode = DASH_MODE.TRANSITION_LINE;
        if (this.mTransitionLineWidthValueAnimator == null) {
            this.mTransitionLineWidthValueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mnTransitionProgress});
            this.mTransitionLineWidthValueAnimator.setFloatValues(new float[]{0.0f, 1.0f});
            this.mTransitionLineWidthValueAnimator.setDuration(400L);
            this.mTransitionLineWidthValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mTransitionLineWidthValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    DashSpinner.this.mnTransitionProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    DashSpinner.this.postInvalidate();
                }
            });
            this.mTransitionLineWidthValueAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    DashSpinner.this.startStateTransition();
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else if (this.mTransitionLineWidthValueAnimator.isRunning()) {
            this.mTransitionLineWidthValueAnimator.cancel();
        }
        this.mTransitionLineWidthValueAnimator.start();
    }

    private void startStateTransition() {
        this.mCurrentDashMode = this.mNextDashMode;
        this.mNextDashMode = DASH_MODE.NONE;
        if (this.mTransitionToStateValueAnimator == null) {
            this.mTransitionToStateValueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mnTransitionProgress});
            this.mTransitionToStateValueAnimator.setFloatValues(new float[]{0.0f, 1.0f});
            this.mTransitionToStateValueAnimator.setDuration(400L);
            this.mTransitionToStateValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            this.mTransitionToStateValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    DashSpinner.this.mnTransitionProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    DashSpinner.this.postInvalidate();
                }
            });
            this.mTransitionToStateValueAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    DashSpinner.this.mCompletionHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (DashSpinner.this.mOnDownloadIntimationListener != null) {
                                DashSpinner.this.mOnDownloadIntimationListener.onDownloadIntimationDone(DashSpinner.this.mCurrentDashMode);
                            }
                        }
                    }, 400L);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        } else if (this.mTransitionToStateValueAnimator.isRunning()) {
            this.mTransitionToStateValueAnimator.cancel();
        }
        this.mTransitionToStateValueAnimator.start();
    }

    public static enum DASH_MODE {
        NONE,
        DOWNLOAD,
        TRANSITION_TEXT_AND_CIRCLE,
        TRANSITION_LINE,
        SUCCESS,
        FAILURE,
        UNKNOWN;

    }

    public static interface OnDownloadIntimationListener {
        public void onDownloadIntimationDone(DASH_MODE var1);
    }
}

