/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.rs485serial;

import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import org.tcshare.utils.ShellUtils;
import org.tcshare.utils.rs485serial.RS485SerialPort;

public class RS485SerialPortUtilNewReceiveOnly {
    private static final String TAG = RS485SerialPortUtilNewReceiveOnly.class.getSimpleName();
    private boolean DEBUG = false;
    private RS485SerialPort rs485SerialPort = new RS485SerialPort();
    private ReadOnlyThread mReadOnlyThread;
    private boolean mWriteReadThreadStop = false;
    private boolean isOpenSerialSuccess;
    private long waitSlaverTime = 10L;
    private final Object locker = new Object();
    private OnReceiveCallback onReceiveCallback;

    public RS485SerialPortUtilNewReceiveOnly() {
        this(100L);
    }

    public RS485SerialPortUtilNewReceiveOnly(long waitSlaverTime) {
        this.waitSlaverTime = waitSlaverTime;
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int band, @NonNull String port, String rs485Path, boolean hasDriver) {
        block6: {
            try {
                String cmdPort = "chmod 777 " + port;
                ShellUtils.CommandResult cmdPortResult = ShellUtils.execCommand(cmdPort, true);
                Log.d((String)TAG, (String)String.format("exe command: %s result %s", cmdPort, cmdPortResult.toString()));
                if (rs485Path != null) {
                    String cmdEnable = "chmod 777 " + rs485Path;
                    ShellUtils.CommandResult cmdEnableResult = ShellUtils.execCommand(cmdEnable, true);
                    Log.d((String)TAG, (String)String.format("exe command: %s result %s", cmdEnable, cmdEnableResult.toString()));
                }
                int result = this.rs485SerialPort.open(port, rs485Path, band, 0, hasDriver);
                this.mWriteReadThreadStop = false;
                this.mReadOnlyThread = new ReadOnlyThread();
                this.mReadOnlyThread.start();
                if (result != -1) {
                    this.isOpenSerialSuccess = true;
                    break block6;
                }
                this.isOpenSerialSuccess = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"\u6253\u5f00\u4e32\u53e3\u65f6\uff0c\u5f02\u5e38");
                this.isOpenSerialSuccess = false;
            }
        }
    }

    public boolean isOpenSerialSuccess() {
        return this.isOpenSerialSuccess;
    }

    public void destroy() {
        try {
            if (this.mReadOnlyThread != null) {
                this.mWriteReadThreadStop = true;
                this.mReadOnlyThread.interrupt();
                this.mReadOnlyThread = null;
            }
            if (this.rs485SerialPort != null) {
                this.rs485SerialPort.close();
                this.rs485SerialPort = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnReceiveCallback(OnReceiveCallback onReceiveCallback) {
        this.onReceiveCallback = onReceiveCallback;
    }

    static {
        System.loadLibrary("tc_serialport_n");
    }

    public static interface OnReceiveCallback {
        public void onReceive(byte[] var1);
    }

    private class ReadOnlyThread
    extends Thread {
        public ReadOnlyThread() {
            Process.setThreadPriority((int)-19);
        }

        @Override
        public void run() {
            super.run();
            while (!RS485SerialPortUtilNewReceiveOnly.this.mWriteReadThreadStop && !this.isInterrupted()) {
                try {
                    byte[] ret = null;
                    while ((ret = RS485SerialPortUtilNewReceiveOnly.this.rs485SerialPort.drain(300)) != null) {
                        if (RS485SerialPortUtilNewReceiveOnly.this.onReceiveCallback != null && ret.length > 0) {
                            RS485SerialPortUtilNewReceiveOnly.this.onReceiveCallback.onReceive(ret);
                        }
                        if (RS485SerialPortUtilNewReceiveOnly.this.waitSlaverTime <= 0L) continue;
                        try {
                            Thread.sleep(RS485SerialPortUtilNewReceiveOnly.this.waitSlaverTime);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RS485SerialPortUtilNewReceiveOnly.this.isOpenSerialSuccess = false;
                    RS485SerialPortUtilNewReceiveOnly.this.destroy();
                    return;
                }
            }
        }
    }
}

