/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils.rs485serial;

import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.tcshare.utils.HexDump;
import org.tcshare.utils.ShellUtils;
import org.tcshare.utils.rs485serial.RS485SerialPort;

public class RS485SerialPortUtilNew {
    private static final String TAG = RS485SerialPortUtilNew.class.getSimpleName();
    private boolean DEBUG = false;
    private RS485SerialPort rs485SerialPort = new RS485SerialPort();
    private WriteReadThread mWriteReadThread;
    private boolean mWriteReadThreadStop = false;
    private boolean isOpenSerialSuccess;
    private LinkedBlockingDeque<RSCallback> rsBlockingQueue;
    private long waitSlaverTime = 10L;
    private boolean syncSending = false;
    private final Object locker = new Object();

    public RS485SerialPortUtilNew() {
        this(Integer.MAX_VALUE, 100L);
    }

    public RS485SerialPortUtilNew(int queueSize, long waitSlaverTime) {
        this.rsBlockingQueue = new LinkedBlockingDeque(queueSize);
        this.waitSlaverTime = waitSlaverTime;
    }

    public RS485SerialPortUtilNew(long waitSlaverTime) {
        this(1000, waitSlaverTime);
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int band, @NonNull String port, String rs485Path, boolean hasDriver) {
        block6: {
            try {
                String cmdPort = "chmod 777 " + port;
                ShellUtils.CommandResult cmdPortResult = ShellUtils.execCommand(cmdPort, true);
                Log.d((String)TAG, (String)String.format("exe command: %s result %s", cmdPort, cmdPortResult.toString()));
                if (rs485Path != null) {
                    String cmdEnable = "chmod 777 " + rs485Path;
                    ShellUtils.CommandResult cmdEnableResult = ShellUtils.execCommand(cmdEnable, true);
                    Log.d((String)TAG, (String)String.format("exe command: %s result %s", cmdEnable, cmdEnableResult.toString()));
                }
                int result = this.rs485SerialPort.open(port, rs485Path, band, 0, hasDriver);
                this.mWriteReadThreadStop = false;
                this.mWriteReadThread = new WriteReadThread();
                this.mWriteReadThread.start();
                if (result != -1) {
                    this.isOpenSerialSuccess = true;
                    break block6;
                }
                this.isOpenSerialSuccess = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"\u6253\u5f00\u4e32\u53e3\u65f6\uff0c\u5f02\u5e38");
                this.isOpenSerialSuccess = false;
            }
        }
    }

    public boolean isOpenSerialSuccess() {
        return this.isOpenSerialSuccess;
    }

    public void destroy() {
        try {
            if (this.mWriteReadThread != null) {
                this.mWriteReadThreadStop = true;
                this.mWriteReadThread.interrupt();
                this.mWriteReadThread = null;
            }
            if (this.rs485SerialPort != null) {
                this.rs485SerialPort.close();
                this.rs485SerialPort = null;
            }
            this.rsBlockingQueue.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendData(@NonNull RSCallback cb) {
        try {
            this.rsBlockingQueue.put(cb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendDataSync(byte[] sendArray, int revBufSize, int readWaitTime) {
        byte[] recBytes = null;
        if (this.DEBUG) {
            Log.d((String)TAG, (String)("------rsync send Bytes: " + HexDump.toHexString(sendArray)));
        }
        Object object = this.locker;
        synchronized (object) {
            this.syncSending = true;
            recBytes = this.rs485SerialPort.send(sendArray, revBufSize, readWaitTime);
            this.syncSending = false;
        }
        if (this.DEBUG) {
            Log.d((String)TAG, (String)("------rsync recv Bytes: " + (recBytes == null ? "null " : HexDump.toHexString(recBytes))));
        }
        if (this.waitSlaverTime > 0L) {
            try {
                Thread.sleep(this.waitSlaverTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return recBytes;
    }

    public void sendDataInsertHead(@NonNull RSCallback cb) {
        cb.level = Long.MAX_VALUE;
        try {
            this.rsBlockingQueue.addFirst(cb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int queueSize() {
        return this.rsBlockingQueue.size();
    }

    public boolean contains(RSCallback rs) {
        return this.rsBlockingQueue.contains(rs);
    }

    static {
        System.loadLibrary("tc_serialport_n");
    }

    private class WriteReadThread
    extends Thread {
        public WriteReadThread() {
            Process.setThreadPriority((int)-19);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            while (!RS485SerialPortUtilNew.this.mWriteReadThreadStop && !this.isInterrupted()) {
                try {
                    RSCallback obj;
                    while ((obj = (RSCallback)RS485SerialPortUtilNew.this.rsBlockingQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) {
                        if (RS485SerialPortUtilNew.this.syncSending) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (RS485SerialPortUtilNew.this.rs485SerialPort == null) continue;
                        Object object = RS485SerialPortUtilNew.this.locker;
                        synchronized (object) {
                            RS485SerialPortUtilNew.this.rs485SerialPort.drain(1);
                        }
                    }
                    if (obj.sendBytes.length == 0) {
                        obj.onReceiveFinish(null);
                        continue;
                    }
                    if (RS485SerialPortUtilNew.this.DEBUG) {
                        Log.d((String)TAG, (String)("------send Bytes: " + HexDump.toHexString(obj.sendBytes)));
                    }
                    byte[] recBytes = null;
                    Object object = RS485SerialPortUtilNew.this.locker;
                    synchronized (object) {
                        recBytes = RS485SerialPortUtilNew.this.rs485SerialPort.send(obj.sendBytes, obj.recBufLen, obj.waitTime);
                    }
                    if (RS485SerialPortUtilNew.this.DEBUG) {
                        Log.d((String)TAG, (String)("------recv Bytes: " + (recBytes == null ? "null " : HexDump.toHexString(recBytes))));
                    }
                    obj.onReceiveFinish(recBytes);
                    if (RS485SerialPortUtilNew.this.waitSlaverTime <= 0L) continue;
                    try {
                        Thread.sleep(RS485SerialPortUtilNew.this.waitSlaverTime);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RS485SerialPortUtilNew.this.isOpenSerialSuccess = false;
                    RS485SerialPortUtilNew.this.destroy();
                    return;
                }
            }
        }
    }

    public static abstract class RSCallback
    implements Comparable<RSCallback> {
        public byte[] sendBytes;
        public int recBufLen;
        public int waitTime;
        public long level = 0L;
        public String id;

        public RSCallback setId(String id2) {
            this.id = id2;
            return this;
        }

        public RSCallback setLevel(long level) {
            this.level = level;
            return this;
        }

        public RSCallback(@NonNull byte[] sendData, int recBufLen, int waitTime) {
            this.sendBytes = sendData;
            this.recBufLen = recBufLen;
            this.waitTime = waitTime;
        }

        public RSCallback(@NonNull byte[] sendData, int recBufLen, int waitTime, long level) {
            this.sendBytes = sendData;
            this.recBufLen = recBufLen;
            this.waitTime = waitTime;
            this.level = level;
        }

        public abstract void onReceiveFinish(byte[] var1);

        @Override
        public int compareTo(RSCallback o) {
            return Long.compare(o.level, this.level);
        }

        public boolean equals(Object o) {
            RSCallback that = (RSCallback)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static class EmptyRSCallback
    extends RSCallback {
        public EmptyRSCallback(String id2) {
            super(new byte[0], 0, 0);
            this.id = id2;
        }

        @Override
        public void onReceiveFinish(byte[] recBytes) {
        }

        @Override
        public boolean equals(Object o) {
            RSCallback that = (RSCallback)o;
            return Objects.equals(this.id, that.id);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

