/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import org.tcshare.androidutils.R;
import org.tcshare.utils.DensityUtil;

public class ToastUtil {
    private static Toast toast;

    public static void showToastLong(Context context, String msg) {
        ToastUtil.showToast(context, msg, 1);
    }

    public static void showToastLong(Context context, int msgID) {
        ToastUtil.showToast(context, context.getResources().getString(msgID), 1);
    }

    public static void showToastShort(Context context, String msg) {
        ToastUtil.showToast(context, msg, 0);
    }

    public static void showToastShort(Context context, int msgID) {
        ToastUtil.showToast(context, context.getResources().getString(msgID), 0);
    }

    public static void showToastLong(Context context, String msg, @Nullable Integer bgColor, int fSize, @Nullable Integer fColor, int w, int h) {
        ToastUtil.showToast(context, msg, 1, bgColor, fSize, fColor, w, h);
    }

    public static void showToastLong(Context context, int msgID, @Nullable Integer bgColor, int fSize, @Nullable Integer fColor, int w, int h) {
        ToastUtil.showToast(context, context.getResources().getString(msgID), 1, bgColor, fSize, fColor, w, h);
    }

    public static void showToastShort(Context context, String msg, @Nullable Integer bgColor, int fSize, @Nullable Integer fColor, int w, int h) {
        ToastUtil.showToast(context, msg, 0, bgColor, fSize, fColor, w, h);
    }

    public static void showToastShort(Context context, int msgID, @Nullable Integer bgColor, int fSize, @Nullable Integer fColor, int w, int h) {
        ToastUtil.showToast(context, context.getResources().getString(msgID), 0, bgColor, fSize, fColor, w, h);
    }

    private static void showToast(Context context, String msg, int duration) {
        if (toast != null) {
            toast.cancel();
        }
        toast = Toast.makeText((Context)context, (CharSequence)msg, (int)duration);
        if (Build.VERSION.SDK_INT < 30) {
            View view = toast.getView();
            view.setBackgroundResource(R.drawable.bg_toast);
            TextView message = (TextView)view.findViewById(16908299);
            message.setTextColor(-1);
            message.setGravity(17);
            message.setPadding(DensityUtil.dp2px(context, 10), DensityUtil.dp2px(context, 6), DensityUtil.dp2px(context, 10), DensityUtil.dp2px(context, 6));
            toast.setGravity(17, 0, 0);
        }
        toast.show();
    }

    private static void showToast(Context context, String msg, int duration, @Nullable Integer bgColor, int fSize, @Nullable Integer fColor, int w, int h) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)msg, (int)duration);
        if (Build.VERSION.SDK_INT < 30) {
            View view = toast.getView();
            view.setBackgroundResource(R.drawable.bg_toast);
            if (bgColor != null) {
                view.setBackgroundTintList(ColorStateList.valueOf((int)bgColor));
            }
            TextView message = (TextView)view.findViewById(16908299);
            if (fColor != null) {
                message.setTextColor(fColor.intValue());
            } else {
                message.setTextColor(-1);
            }
            message.setTextSize(1, (float)fSize);
            ViewGroup.LayoutParams layoutParams = message.getLayoutParams();
            layoutParams.width = w;
            layoutParams.height = h;
            message.setLayoutParams(layoutParams);
            message.setGravity(17);
            message.setPadding(DensityUtil.dp2px(context, 10), DensityUtil.dp2px(context, 6), DensityUtil.dp2px(context, 10), DensityUtil.dp2px(context, 6));
            toast.setGravity(17, 0, 0);
        }
        toast.show();
    }
}

