/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.net.Uri;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;

public class SelectPicture {
    static int MAX_WIDTH = 4096;
    static int MAX_HEIGHT = 4096;
    Uri uri;
    ContentResolver resolver;
    String path;
    Matrix orientation;
    int storedHeight;
    int storedWidth;

    public SelectPicture(Uri uri, ContentResolver resolver) {
        this.uri = uri;
        this.resolver = resolver;
    }

    private boolean getInformation() throws IOException {
        if (this.getInformationFromMediaDatabase()) {
            return true;
        }
        return this.getInformationFromFileSystem();
    }

    private boolean getInformationFromMediaDatabase() {
        String[] fields = new String[]{"_data", "orientation"};
        Cursor cursor = this.resolver.query(this.uri, fields, null, null, null);
        if (cursor == null) {
            return false;
        }
        cursor.moveToFirst();
        this.path = cursor.getString(cursor.getColumnIndex("_data"));
        int orientation = cursor.getInt(cursor.getColumnIndex("orientation"));
        this.orientation = new Matrix();
        this.orientation.setRotate((float)orientation);
        cursor.close();
        return true;
    }

    private boolean getInformationFromFileSystem() throws IOException {
        this.path = this.uri.getPath();
        if (this.path == null) {
            return false;
        }
        ExifInterface exif = new ExifInterface(this.path);
        int orientation = exif.getAttributeInt("Orientation", 1);
        this.orientation = new Matrix();
        switch (orientation) {
            case 1: {
                break;
            }
            case 2: {
                this.orientation.setScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                this.orientation.setRotate(180.0f);
                break;
            }
            case 4: {
                this.orientation.setScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                this.orientation.setRotate(90.0f);
                this.orientation.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                this.orientation.setRotate(90.0f);
                break;
            }
            case 7: {
                this.orientation.setRotate(-90.0f);
                this.orientation.postScale(-1.0f, 1.0f);
                break;
            }
            case 8: {
                this.orientation.setRotate(-90.0f);
            }
        }
        return true;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return this.resolver.openInputStream(this.uri);
    }

    private boolean getStoredDimensions() throws IOException {
        InputStream input = this.resolver.openInputStream(this.uri);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)this.resolver.openInputStream(this.uri), null, (BitmapFactory.Options)options);
        input.close();
        if (options.outHeight <= 0 || options.outWidth <= 0) {
            return false;
        }
        this.storedHeight = options.outHeight;
        this.storedWidth = options.outWidth;
        return true;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Bitmap getBitmap() throws IOException {
        Bitmap picture;
        if (!this.getInformation()) {
            throw new FileNotFoundException();
        }
        if (!this.getStoredDimensions()) {
            throw new InvalidObjectException(null);
        }
        RectF rect = new RectF(0.0f, 0.0f, (float)this.storedWidth, (float)this.storedHeight);
        this.orientation.mapRect(rect);
        int width = (int)rect.width();
        int height = (int)rect.height();
        int subSample = 1;
        while (width > MAX_WIDTH || height > MAX_HEIGHT) {
            width /= 2;
            height /= 2;
            subSample *= 2;
        }
        if (width == 0 || height == 0) {
            throw new InvalidObjectException(null);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = subSample;
        Bitmap subSampled = BitmapFactory.decodeStream((InputStream)this.resolver.openInputStream(this.uri), null, (BitmapFactory.Options)options);
        if (!this.orientation.isIdentity()) {
            picture = Bitmap.createBitmap((Bitmap)subSampled, (int)0, (int)0, (int)options.outWidth, (int)options.outHeight, (Matrix)this.orientation, (boolean)false);
            subSampled.recycle();
        } else {
            picture = subSampled;
        }
        return picture;
    }
}

