/*
 * Decompiled with CFR 0.152.
 */
package org.tcshare.utils;

import android.text.InputFilter;
import android.text.Spanned;
import org.tcshare.utils.SpanStringCountUtil;

public class InputLenthFilter
extends InputFilter.LengthFilter {
    private int max;
    private boolean spanAsOne;

    public InputLenthFilter(int max) {
        this(max, false);
    }

    public InputLenthFilter(int max, boolean spanAsOne) {
        super(max);
        this.max = max;
        this.spanAsOne = spanAsOne;
    }

    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        int wordLen = 0;
        if (this.spanAsOne) {
            SpanStringCountUtil countUtil = new SpanStringCountUtil(source);
            wordLen = countUtil.countWords();
        } else {
            wordLen = source.length();
        }
        if (wordLen > this.max) {
            return null;
        }
        return super.filter(source, start, end, dest, dstart, dend);
    }
}

